/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.frs.v2.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huaweicloud.sdk.core.http.FormDataFilePart;
import com.huaweicloud.sdk.core.http.FormDataPart;
import com.huaweicloud.sdk.core.http.SdkFormDataBody;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class DetectLiveByFileRequestBody
implements SdkFormDataBody {
    @JsonProperty(value="video_file", access=JsonProperty.Access.WRITE_ONLY)
    private FormDataFilePart videoFile;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="actions")
    private String actions;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="action_time")
    private String actionTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="nod_threshold")
    private Double nodThreshold;

    public DetectLiveByFileRequestBody withVideoFile(FormDataFilePart videoFile) {
        this.videoFile = videoFile;
        return this;
    }

    public FormDataFilePart getVideoFile() {
        return this.videoFile;
    }

    public void setVideoFile(FormDataFilePart videoFile) {
        this.videoFile = videoFile;
    }

    public DetectLiveByFileRequestBody withActions(String actions) {
        this.actions = actions;
        return this;
    }

    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    public DetectLiveByFileRequestBody withActionTime(String actionTime) {
        this.actionTime = actionTime;
        return this;
    }

    public String getActionTime() {
        return this.actionTime;
    }

    public void setActionTime(String actionTime) {
        this.actionTime = actionTime;
    }

    public DetectLiveByFileRequestBody withNodThreshold(Double nodThreshold) {
        this.nodThreshold = nodThreshold;
        return this;
    }

    public Double getNodThreshold() {
        return this.nodThreshold;
    }

    public void setNodThreshold(Double nodThreshold) {
        this.nodThreshold = nodThreshold;
    }

    public DetectLiveByFileRequestBody withVideoFile(InputStream inputStream, String fileName, String contentType) {
        this.videoFile = new FormDataFilePart(inputStream, fileName).withContentType(contentType);
        return this;
    }

    public DetectLiveByFileRequestBody withVideoFile(InputStream inputStream, String fileName) {
        this.videoFile = new FormDataFilePart(inputStream, fileName);
        return this;
    }

    public DetectLiveByFileRequestBody withVideoFile(InputStream inputStream, String fileName, Map<String, String> headers) {
        this.videoFile = new FormDataFilePart(inputStream, fileName).withHeaders(headers);
        return this;
    }

    public Map<String, FormDataPart<?>> buildFormData() {
        return new LinkedHashMap<String, FormDataPart<?>>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("video_file", DetectLiveByFileRequestBody.this.videoFile);
                this.put("actions", new FormDataPart((Object)DetectLiveByFileRequestBody.this.actions));
                if (DetectLiveByFileRequestBody.this.actionTime != null) {
                    this.put("action_time", new FormDataPart((Object)DetectLiveByFileRequestBody.this.actionTime));
                }
                if (DetectLiveByFileRequestBody.this.nodThreshold != null) {
                    this.put("nod_threshold", new FormDataPart((Object)DetectLiveByFileRequestBody.this.nodThreshold));
                }
            }
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DetectLiveByFileRequestBody that = (DetectLiveByFileRequestBody)obj;
        return Objects.equals(this.videoFile, that.videoFile) && Objects.equals(this.actions, that.actions) && Objects.equals(this.actionTime, that.actionTime) && Objects.equals(this.nodThreshold, that.nodThreshold);
    }

    public int hashCode() {
        return Objects.hash(this.videoFile, this.actions, this.actionTime, this.nodThreshold);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DetectLiveByFileRequestBody {\n");
        sb.append("    videoFile: ").append(this.toIndentedString("[resource:will-not-print]")).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    actionTime: ").append(this.toIndentedString(this.actionTime)).append("\n");
        sb.append("    nodThreshold: ").append(this.toIndentedString(this.nodThreshold)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

