/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.internal.xml.OBSXMLBuilder;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ServiceException
extends RuntimeException {
    private static final long serialVersionUID = -757626557833455141L;
    private String xmlMessage;
    private String errorCode;
    private String errorMessage;
    private String errorRequestId;
    private String errorHostId;
    private Map<String, String> responseHeaders;
    private int responseCode = -1;
    private String responseStatus;
    private String responseDate;
    private String requestVerb;
    private String requestPath;
    private String requestHost;
    private String errorIndicator;
    private String encodedAuthorizationMessage;

    public ServiceException(String message, String xmlMessage) {
        this(message, xmlMessage, null);
    }

    public ServiceException(String message, String xmlMessage, Throwable cause) {
        super(message, cause);
        if (ServiceUtils.isValid(xmlMessage)) {
            this.parseXmlMessage(xmlMessage);
        }
    }

    public ServiceException() {
    }

    public ServiceException(String message, Throwable cause) {
        super(message, cause);
    }

    public ServiceException(String message) {
        super(message);
    }

    public ServiceException(Throwable cause) {
        super(cause);
    }

    @Override
    public String toString() {
        StringBuilder myString = new StringBuilder(super.toString());
        if (this.requestVerb != null) {
            myString.append(" ").append(this.requestVerb).append(" '").append(this.requestPath).append("'").append(this.requestHost != null ? " on Host '" + this.requestHost + "'" : "").append(this.responseDate != null ? " @ '" + this.responseDate + "'" : "");
        }
        if (this.responseCode != -1) {
            myString.append(" -- ResponseCode: ").append(this.responseCode).append(", ResponseStatus: ").append(this.responseStatus);
        }
        if (this.isParsedFromXmlMessage()) {
            myString.append(", XML Error Message: ").append(this.xmlMessage);
        } else if (this.errorRequestId != null) {
            myString.append(", RequestId: ").append(this.errorRequestId).append(", HostId: ").append(this.errorHostId);
        }
        return myString.toString();
    }

    private String findXmlElementText(String xmlMessage, String elementName) {
        Pattern pattern = Pattern.compile(".*<" + elementName + ">(.*)</" + elementName + ">.*");
        Matcher matcher = pattern.matcher(xmlMessage);
        if (matcher.matches() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }

    private void parseXmlMessage(String xmlMessage) {
        this.xmlMessage = xmlMessage = xmlMessage.replaceAll("\n", "");
        this.errorCode = this.findXmlElementText(xmlMessage, "Code");
        this.errorMessage = this.findXmlElementText(xmlMessage, "Message");
        this.errorRequestId = this.findXmlElementText(xmlMessage, "RequestId");
        this.errorHostId = this.findXmlElementText(xmlMessage, "HostId");
        String errorDetails = this.findXmlElementText(xmlMessage, "Details");
        if (errorDetails != null && errorDetails.length() > 0) {
            this.errorMessage = this.errorMessage + " " + errorDetails;
        }
        this.encodedAuthorizationMessage = this.findXmlElementText(xmlMessage, "EncodedAuthorizationMessage");
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String code) {
        this.errorCode = code;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public String getErrorHostId() {
        return this.errorHostId;
    }

    public void setErrorHostId(String hostId) {
        this.errorHostId = hostId;
    }

    public String getErrorRequestId() {
        return this.errorRequestId;
    }

    public void setErrorRequestId(String requestId) {
        this.errorRequestId = requestId;
    }

    public String getXmlMessage() {
        return this.xmlMessage;
    }

    public OBSXMLBuilder getXmlMessageAsBuilder() throws IOException, ParserConfigurationException, SAXException {
        if (this.xmlMessage == null) {
            return null;
        }
        OBSXMLBuilder builder = OBSXMLBuilder.parse(new InputSource(new StringReader(this.xmlMessage)));
        return builder;
    }

    public boolean isParsedFromXmlMessage() {
        return this.xmlMessage != null;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(String responseStatus) {
        this.responseStatus = responseStatus;
    }

    public String getResponseDate() {
        return this.responseDate;
    }

    public void setResponseDate(String responseDate) {
        this.responseDate = responseDate;
    }

    public String getRequestVerb() {
        return this.requestVerb;
    }

    public void setRequestVerb(String requestVerb) {
        this.requestVerb = requestVerb;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public String getRequestHost() {
        return this.requestHost;
    }

    public void setRequestHost(String requestHost) {
        this.requestHost = requestHost;
    }

    public void setRequestAndHostIds(String errorRequestId, String errorHostId) {
        this.errorRequestId = errorRequestId;
        this.errorHostId = errorHostId;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, String> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public String getErrorIndicator() {
        return this.errorIndicator;
    }

    public void setErrorIndicator(String errorIndicator) {
        this.errorIndicator = errorIndicator;
    }

    public String getEncodedAuthorizationMessage() {
        return this.encodedAuthorizationMessage;
    }

    public void setEncodedAuthorizationMessage(String encodedAuthorizationMessage) {
        this.encodedAuthorizationMessage = encodedAuthorizationMessage;
    }
}

