/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SecureObjectInputStream
extends ObjectInputStream {
    public static final List<String> ALLOWED_CLASS_NAMES = Collections.unmodifiableList(Arrays.asList("java.util.ArrayList", "com.obs.services.model.PartEtag", "java.lang.Integer", "java.lang.Number", "java.util.Date", "com.obs.services.internal.DownloadResumableClient$TmpFileStatus", "com.obs.services.internal.UploadResumableClient$UploadCheckPoint", "com.obs.services.internal.UploadResumableClient$FileStatus", "com.obs.services.internal.UploadResumableClient$UploadPart", "com.obs.services.internal.DownloadResumableClient$DownloadCheckPoint", "com.obs.services.internal.DownloadResumableClient$DownloadPart", "com.obs.services.internal.DownloadResumableClient$ObjectStatus", "com.obs.services.internal.utils.CRC64", "java.util.concurrent.ConcurrentHashMap", "[Ljava.util.concurrent.ConcurrentHashMap$Segment;", "java.util.concurrent.ConcurrentHashMap$Segment", "java.util.concurrent.locks.ReentrantLock", "java.util.concurrent.locks.ReentrantLock$NonfairSync", "java.util.concurrent.locks.ReentrantLock$Sync", "java.util.concurrent.locks.AbstractQueuedSynchronizer", "java.util.concurrent.locks.AbstractOwnableSynchronizer"));

    public SecureObjectInputStream() throws IOException, SecurityException {
    }

    public SecureObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        if (!ALLOWED_CLASS_NAMES.contains(name)) {
            throw new ClassNotFoundException(name + "not find");
        }
        return super.resolveClass(desc);
    }
}

