/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.Constants;
import com.obs.services.internal.IHeaders;
import com.obs.services.internal.RestStorageService;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.CRC64;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.AvailableZoneEnum;
import com.obs.services.model.BaseObjectRequest;
import com.obs.services.model.BucketTypeEnum;
import com.obs.services.model.GenericRequest;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.fs.FSStatusEnum;
import com.obs.services.model.fs.GetBucketFSStatusResult;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class AbstractRequestConvertor
extends RestStorageService {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");

    protected Map<String, String> transRequestPaymentHeaders(boolean isRequesterPays, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (isRequesterPays) {
            if (null == headers) {
                headers = new HashMap<String, String>();
            }
            this.putHeader(headers, iheaders.requestPaymentHeader(), "requester");
        }
        return headers;
    }

    protected Map<String, String> transRequestPaymentHeaders(GenericRequest request, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (null != request) {
            return this.transRequestPaymentHeaders(request.isRequesterPays(), headers, iheaders);
        }
        return null;
    }

    protected String getHeaderByMethodName(String bucketName, String code) {
        try {
            IHeaders iheaders = this.getIHeaders(bucketName);
            Method m = iheaders.getClass().getMethod(code, new Class[0]);
            Object result = m.invoke((Object)iheaders, new Object[0]);
            return result == null ? "" : result.toString();
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn("Invoke getHeaderByMethodName error", e);
            }
            return null;
        }
    }

    protected void putHeader(Map<String, String> headers, String key, String value) {
        if (ServiceUtils.isValid(key)) {
            headers.put(key, value);
        }
    }

    protected HeaderResponse build(Response res) {
        HeaderResponse response = new HeaderResponse();
        this.setHeadersAndStatus(response, res);
        return response;
    }

    protected void setHeadersAndStatus(HeaderResponse response, Response res) {
        this.setHeadersAndStatus(response, res, true);
    }

    protected void setHeadersAndStatus(HeaderResponse response, Response res, boolean needDecode) {
        response.setStatusCode(res.code());
        Map headerMap = res.headers().toMultimap();
        TreeMap<String, Object> originalHeaders = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        TreeMap<String, Object> responseHeaders = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry entry : headerMap.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            if (key == null || values == null) continue;
            List originalValue = values.size() == 1 ? values.get(0) : values;
            originalHeaders.put(key, originalValue);
            this.putCleanedKeyAndValues(responseHeaders, key, values, needDecode);
        }
        response.setOriginalHeaders(originalHeaders);
        response.setResponseHeaders(responseHeaders);
    }

    protected void putCleanedKeyAndValues(Map<String, Object> responseHeaders, String key, List<String> values, boolean needDecode) {
        ArrayList<String> finalValues;
        String cleanedKey;
        block15: {
            ArrayList<String> cleanedValues;
            block16: {
                cleanedKey = key.toLowerCase(Locale.ROOT);
                cleanedValues = new ArrayList<String>(values.size());
                if ("Date".equalsIgnoreCase(key) || "Last-Modified".equalsIgnoreCase(key)) {
                    finalValues = values.get(0);
                    if (log.isDebugEnabled()) {
                        log.debug("Parsing date string '" + finalValues + "' into Date object for key: " + key);
                    }
                    try {
                        finalValues = ServiceUtils.parseRfc822Date(((Object)finalValues).toString());
                    }
                    catch (ParseException pe) {
                        try {
                            finalValues = ServiceUtils.parseIso8601Date(((Object)finalValues).toString());
                            break block15;
                        }
                        catch (ParseException pe2) {
                            if (log.isWarnEnabled()) {
                                log.warn("Date string is not RFC 822 or ISO-8601 compliant for metadata field " + key, pe);
                            }
                            break block15;
                        }
                    }
                }
                for (String prefix : Constants.NOT_NEED_HEADER_PREFIXES) {
                    if (!key.toLowerCase(Locale.ROOT).startsWith(prefix)) continue;
                    cleanedKey = cleanedKey.replace(prefix, "");
                    break;
                }
                for (String value : values) {
                    if (needDecode) {
                        try {
                            cleanedValues.add(URLDecoder.decode(value, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException | IllegalArgumentException e) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Error to decode value of key:" + key);
                        }
                        continue;
                    }
                    cleanedValues.add(value);
                }
                if (needDecode) {
                    try {
                        cleanedKey = URLDecoder.decode(cleanedKey, "UTF-8");
                    }
                    catch (UnsupportedEncodingException | IllegalArgumentException e) {
                        if (!log.isWarnEnabled()) break block16;
                        log.debug("Error to decode key:" + key);
                    }
                }
            }
            finalValues = cleanedValues.size() == 1 ? cleanedValues.get(0) : cleanedValues;
        }
        responseHeaders.put(cleanedKey, finalValues);
    }

    protected SpecialParamEnum getSpecialParamForStorageClass(String bucketName) {
        return this.getProviderCredentials().getLocalAuthType(bucketName) == AuthTypeEnum.OBS ? SpecialParamEnum.STORAGECLASS : SpecialParamEnum.STORAGEPOLICY;
    }

    protected RequestBody createRequestBody(String mimeType, String content) throws ServiceException {
        if (log.isTraceEnabled()) {
            log.trace("Entity Content:" + content);
        }
        return RequestBody.create((byte[])content.getBytes(StandardCharsets.UTF_8), (MediaType)MediaType.parse((String)mimeType));
    }

    protected GetBucketFSStatusResult getOptionInfoResult(String bucketName, Response response) {
        Headers headers = response.headers();
        Map map = headers.toMultimap();
        String maxAge = headers.get("Access-Control-Max-Age");
        IHeaders iheaders = this.getIHeaders(bucketName);
        FSStatusEnum status = FSStatusEnum.getValueFromCode(headers.get(iheaders.fsFileInterfaceHeader()));
        BucketTypeEnum bucketType = BucketTypeEnum.OBJECT;
        if (FSStatusEnum.ENABLED == status) {
            bucketType = BucketTypeEnum.PFS;
        }
        GetBucketFSStatusResult output = new GetBucketFSStatusResult.Builder().allowOrigin(headers.get("Access-Control-Allow-Origin")).allowHeaders((List)map.get("Access-Control-Allow-Headers")).maxAge(maxAge == null ? 0 : Integer.parseInt(maxAge)).allowMethods((List)map.get("Access-Control-Allow-Methods")).exposeHeaders((List)map.get("Access-Control-Expose-Headers")).storageClass(StorageClassEnum.getValueFromCode(headers.get(iheaders.defaultStorageClassHeader()))).location(headers.get(iheaders.bucketRegionHeader())).obsVersion(headers.get(iheaders.serverVersionHeader())).status(status).availableZone(AvailableZoneEnum.getValueFromCode(headers.get(iheaders.azRedundancyHeader()))).epid(headers.get(iheaders.epidHeader())).bucketType(bucketType).build();
        this.setHeadersAndStatus(output, response);
        return output;
    }

    protected AuthTypeEnum getApiVersion(String bucketName) throws ServiceException {
        if (!ServiceUtils.isValid(bucketName)) {
            return this.parseAuthTypeInResponse("");
        }
        return this.parseAuthTypeInResponse(bucketName);
    }

    protected void verifyResponseContentType(Response response) throws ServiceException {
        String contentType;
        if (this.obsProperties.getBoolProperty("obs.verify-content-type", true) && !"application/xml".equalsIgnoreCase(contentType = response.header("Content-Type")) && !"text/xml".equalsIgnoreCase(contentType)) {
            throw new ServiceException("Expected XML document response from OBS but received content type " + contentType);
        }
    }

    protected void verifyResponseContentTypeForJson(Response response) throws ServiceException {
        if (this.obsProperties.getBoolProperty("obs.verify-content-type", true)) {
            String contentType = response.header("Content-Type");
            if (null == contentType) {
                throw new ServiceException("Expected JSON document response  but received content type is null");
            }
            if (!contentType.contains("application/json")) {
                throw new ServiceException("Expected JSON document response  but received content type is " + contentType);
            }
        }
    }

    private AuthTypeEnum parseAuthTypeInResponse(String bucketName) throws ServiceException {
        String apiVersion;
        Response response;
        try {
            response = this.getAuthTypeNegotiationResponseImpl(bucketName);
        }
        catch (ServiceException e) {
            if (e.getResponseCode() == 404 || e.getResponseCode() <= 0 || e.getResponseCode() == 408 || e.getResponseCode() >= 500) {
                throw e;
            }
            return AuthTypeEnum.V2;
        }
        return response.code() == 200 && (apiVersion = response.headers().get("x-obs-api")) != null && apiVersion.compareTo("3.0") >= 0 ? AuthTypeEnum.OBS : AuthTypeEnum.V2;
    }

    private Response getAuthTypeNegotiationResponseImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("apiversion", "");
        return this.performRestForApiVersion(bucketName, null, requestParameters, null);
    }

    protected NewTransResult transRequestWithResult(TransResult result, GenericRequest request) {
        NewTransResult newResult = new NewTransResult();
        newResult.setHttpMethod(request.getHttpMethod());
        newResult.setBucketName(request.getBucketName());
        newResult.setHeaders(result.getHeaders());
        newResult.setUserHeaders(request.getUserHeaders());
        newResult.setBody(result.getBody());
        newResult.setParams(result.getParams());
        return newResult;
    }

    protected NewTransResult transObjectRequestWithResult(TransResult result, BaseObjectRequest request) {
        NewTransResult newTransResult = this.transRequestWithResult(result, request);
        newTransResult.setObjectKey(request.getObjectKey());
        newTransResult.setIsEncodeHeaders(request.isEncodeHeaders());
        return newTransResult;
    }

    protected NewTransResult transRequest(GenericRequest request) {
        NewTransResult newResult = new NewTransResult();
        newResult.setHttpMethod(request.getHttpMethod());
        newResult.setBucketName(request.getBucketName());
        newResult.setUserHeaders(request.getUserHeaders());
        return newResult;
    }

    protected NewTransResult transObjectRequest(BaseObjectRequest request) {
        NewTransResult newTransResult = this.transRequest(request);
        newTransResult.setObjectKey(request.getObjectKey());
        newTransResult.setIsEncodeHeaders(request.isEncodeHeaders());
        return newTransResult;
    }

    protected static class TransResult {
        private Map<String, String> headers;
        private Map<String, String> params;
        private Map<String, String> userHeaders = new HashMap<String, String>();
        private RequestBody body;
        private CRC64 calculatedCrc64;

        TransResult(Map<String, String> headers) {
            this(headers, null, null);
        }

        TransResult(Map<String, String> headers, RequestBody body) {
            this(headers, null, body);
        }

        TransResult(Map<String, String> headers, Map<String, String> params, RequestBody body) {
            this.headers = headers;
            this.params = params;
            this.body = body;
        }

        public Map<String, String> getHeaders() {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            return this.headers;
        }

        public Map<String, String> getUserHeaders() {
            return this.userHeaders;
        }

        public void addUserHeaders(String key, String value) {
            this.userHeaders.put(key, value);
        }

        public Map<String, String> getParams() {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            return this.params;
        }

        public void setParams(Map<String, String> params) {
            this.params = params;
        }

        public void setBody(RequestBody body) {
            this.body = body;
        }

        public RequestBody getBody() {
            return this.body;
        }

        public CRC64 getCalculatedCrc64() {
            return this.calculatedCrc64;
        }

        public void setCalculatedCrc64(CRC64 calculatedCrc64) {
            this.calculatedCrc64 = calculatedCrc64;
        }
    }
}

