/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model.fs;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.fs.FSStatusEnum;
import com.obs.services.model.fs.NewFileRequest;
import com.obs.services.model.fs.NewFolderRequest;
import com.obs.services.model.fs.ObsFSFile;
import com.obs.services.model.fs.ObsFSFolder;
import com.obs.services.model.fs.SetBucketFSStatusRequest;
import java.io.File;
import java.io.InputStream;

public class ObsFSBucket {
    protected ObsClient innerClient;
    private String bucketName;
    private String location;

    public ObsFSBucket(String bucketName, String location) {
        this.bucketName = bucketName;
        this.location = location;
    }

    protected void setInnerClient(ObsClient innerClient) {
        this.innerClient = innerClient;
    }

    public HeaderResponse setFSStatus(FSStatusEnum status) throws ObsException {
        this.checkInternalClient();
        return this.innerClient.setBucketFSStatus(new SetBucketFSStatusRequest(this.bucketName, status));
    }

    public ObsFSFolder newFolder(String folderName) throws ObsException {
        this.checkInternalClient();
        return this.innerClient.newFolder(new NewFolderRequest(this.bucketName, folderName));
    }

    public ObsFSFile newFile(String fileName, InputStream input, ObjectMetadata metadata) throws ObsException {
        this.checkInternalClient();
        NewFileRequest request = new NewFileRequest(this.bucketName, fileName);
        request.setInput(input);
        return this.innerClient.newFile(request);
    }

    public ObsFSFile newFile(String fileName, InputStream input) throws ObsException {
        return this.newFile(fileName, input, null);
    }

    public ObsFSFile newFile(String fileName, File file, ObjectMetadata metadata) throws ObsException {
        this.checkInternalClient();
        NewFileRequest request = new NewFileRequest(this.bucketName, fileName);
        request.setFile(file);
        return this.innerClient.newFile(request);
    }

    public ObsFSFile newFile(String fileName, File file) throws ObsException {
        return this.newFile(fileName, file, null);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getLocation() {
        return this.location;
    }

    protected void checkInternalClient() {
        ServiceUtils.assertParameterNotNull(this.innerClient, "ObsClient is null");
    }
}

