/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.model.Owner;
import com.obs.services.model.StorageClassEnum;
import java.util.Date;

public class VersionOrDeleteMarker {
    private String bucketName;
    private String key;
    private String versionId;
    private boolean isLatest;
    private Date lastModified;
    private Owner owner;
    private String etag;
    private long size;
    private StorageClassEnum storageClass;
    private boolean isDeleteMarker;
    private boolean appendable;

    @Deprecated
    public VersionOrDeleteMarker(String bucketName, String key, String versionId, boolean isLatest, Date lastModified, Owner owner, String etag, long size, StorageClassEnum storageClass, boolean isDeleteMarker, boolean appendable) {
        this.bucketName = bucketName;
        this.key = key;
        this.versionId = versionId;
        this.isLatest = isLatest;
        this.lastModified = null != lastModified ? (Date)lastModified.clone() : null;
        this.owner = owner;
        this.etag = etag;
        this.size = size;
        this.storageClass = storageClass;
        this.isDeleteMarker = isDeleteMarker;
        this.appendable = appendable;
    }

    private VersionOrDeleteMarker(Builder builder) {
        this.bucketName = builder.bucketName;
        this.key = builder.key;
        this.versionId = builder.versionId;
        this.isLatest = builder.isLatest;
        this.lastModified = null != builder.lastModified ? (Date)builder.lastModified.clone() : null;
        this.owner = builder.owner;
        this.etag = builder.etag;
        this.size = builder.size;
        this.storageClass = builder.storageClass;
        this.isDeleteMarker = builder.isDeleteMarker;
        this.appendable = builder.appendable;
    }

    public String getKey() {
        return this.key;
    }

    public String getObjectKey() {
        return this.key;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public boolean isLatest() {
        return this.isLatest;
    }

    public Date getLastModified() {
        if (null != this.lastModified) {
            return (Date)this.lastModified.clone();
        }
        return null;
    }

    public Owner getOwner() {
        return this.owner;
    }

    @Deprecated
    public String getStorageClass() {
        return this.storageClass != null ? this.storageClass.getCode() : null;
    }

    public StorageClassEnum getObjectStorageClass() {
        return this.storageClass;
    }

    public String getEtag() {
        return this.etag;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isDeleteMarker() {
        return this.isDeleteMarker;
    }

    public boolean isAppendable() {
        return this.appendable;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String toString() {
        return "VersionOrDeleteMarker [bucketName=" + this.bucketName + ", key=" + this.key + ", versionId=" + this.versionId + ", isLatest=" + this.isLatest + ", lastModified=" + this.lastModified + ", owner=" + this.owner + ", etag=" + this.etag + ", size=" + this.size + ", storageClass=" + (Object)((Object)this.storageClass) + ", isDeleteMarker=" + this.isDeleteMarker + ", appendable=" + this.appendable + "]";
    }

    public static final class Builder {
        private String bucketName;
        private String key;
        private String versionId;
        private boolean isLatest;
        private Date lastModified;
        private Owner owner;
        private String etag;
        private long size;
        private StorageClassEnum storageClass;
        private boolean isDeleteMarker;
        private boolean appendable;

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public Builder isLatest(boolean isLatest) {
            this.isLatest = isLatest;
            return this;
        }

        public Builder lastModified(Date lastModified) {
            this.lastModified = null != lastModified ? (Date)lastModified.clone() : null;
            return this;
        }

        public Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder storageClass(StorageClassEnum storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public Builder isDeleteMarker(boolean isDeleteMarker) {
            this.isDeleteMarker = isDeleteMarker;
            return this;
        }

        public Builder appendable(boolean appendable) {
            this.appendable = appendable;
            return this;
        }

        public VersionOrDeleteMarker builder() {
            return new VersionOrDeleteMarker(this);
        }
    }
}

