/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.RepeatableRequestEntity;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.service.AbstractRequestConvertor;
import com.obs.services.internal.service.ObsMultipartObjectService;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AppendObjectRequest;
import com.obs.services.model.AppendObjectResult;
import com.obs.services.model.ModifyObjectRequest;
import com.obs.services.model.ModifyObjectResult;
import com.obs.services.model.RenameObjectRequest;
import com.obs.services.model.RenameObjectResult;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.RestoreObjectResult;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.TruncateObjectRequest;
import com.obs.services.model.TruncateObjectResult;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Response;

public abstract class ObsObjectService
extends ObsMultipartObjectService {
    private static final ILogger log = LoggerBuilder.getLogger(ObsObjectService.class);

    protected TruncateObjectResult truncateObjectImpl(TruncateObjectRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TRUNCATE.getOriginalStringCode(), "");
        requestParameters.put("length", String.valueOf(request.getNewLength()));
        Response response = this.performRestPut(request.getBucketName(), request.getObjectKey(), this.transRequestPaymentHeaders(request, null, this.getIHeaders()), requestParameters, null, true);
        TruncateObjectResult result = new TruncateObjectResult();
        this.setResponseHeaders(result, this.cleanResponseHeaders(response));
        ObsObjectService.setStatusCode(result, response.code());
        return result;
    }

    protected RenameObjectResult renameObjectImpl(RenameObjectRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.RENAME.getOriginalStringCode(), "");
        requestParameters.put("name", request.getNewObjectKey());
        Response response = this.performRestPost(request.getBucketName(), request.getObjectKey(), this.transRequestPaymentHeaders(request, null, this.getIHeaders()), requestParameters, null, true);
        RenameObjectResult result = new RenameObjectResult();
        this.setResponseHeaders(result, this.cleanResponseHeaders(response));
        ObsObjectService.setStatusCode(result, response.code());
        return result;
    }

    protected RestoreObjectRequest.RestoreObjectStatus restoreObjectImpl(RestoreObjectRequest restoreObjectRequest) throws ServiceException {
        RestoreObjectResult restoreObjectResult = this.restoreObjectV2Impl(restoreObjectRequest);
        return this.transRestoreObjectResultToRestoreObjectStatus(restoreObjectResult);
    }

    protected RestoreObjectResult restoreObjectV2Impl(RestoreObjectRequest restoreObjectRequest) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.RESTORE.getOriginalStringCode(), "");
        if (restoreObjectRequest.getVersionId() != null) {
            requestParameters.put("versionId", restoreObjectRequest.getVersionId());
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        String requestXmlElement = this.getIConvertor().transRestoreObjectRequest(restoreObjectRequest);
        metadata.put("Content-MD5", ServiceUtils.computeMD5(requestXmlElement));
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(restoreObjectRequest, metadata, this.getIHeaders());
        Response response = this.performRestPost(restoreObjectRequest.getBucketName(), restoreObjectRequest.getObjectKey(), metadata, requestParameters, this.createRequestBody("application/xml", requestXmlElement), true);
        RestoreObjectResult ret = new RestoreObjectResult(restoreObjectRequest.getBucketName(), restoreObjectRequest.getObjectKey(), restoreObjectRequest.getVersionId());
        this.setResponseHeaders(ret, this.cleanResponseHeaders(response));
        ObsObjectService.setStatusCode(ret, response.code());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppendObjectResult appendObjectImpl(AppendObjectRequest request) throws ServiceException {
        AppendObjectResult ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            AbstractRequestConvertor.TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transAppendObjectRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
                response = this.performRestPost(request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), result.getBody(), true);
            }
            finally {
                if (result != null && result.getBody() != null && request.isAutoClose()) {
                    RepeatableRequestEntity entity = (RepeatableRequestEntity)result.getBody();
                    ServiceUtils.closeStream(entity);
                }
            }
            String nextPosition = response.header(this.getIHeaders().nextPositionHeader());
            ret = new AppendObjectResult(request.getBucketName(), request.getObjectKey(), response.header("ETag"), nextPosition != null ? Long.parseLong(nextPosition) : -1L, StorageClassEnum.getValueFromCode(response.header(this.getIHeaders().storageClassHeader())), this.getObjectUrl(request.getBucketName(), request.getObjectKey()));
            Map<String, Object> map = this.cleanResponseHeaders(response);
            this.setResponseHeaders(ret, map);
            ObsObjectService.setStatusCode(ret, response.code());
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModifyObjectResult modifyObjectImpl(ModifyObjectRequest request) throws ServiceException {
        ModifyObjectResult ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            AbstractRequestConvertor.TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transModifyObjectRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
                response = this.performRestPut(request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), result.getBody(), true);
            }
            finally {
                if (result != null && result.getBody() != null && request.isAutoClose() && result.getBody() instanceof Closeable) {
                    ServiceUtils.closeStream((Closeable)result.getBody());
                }
            }
            ret = new ModifyObjectResult();
            Map<String, Object> map = this.cleanResponseHeaders(response);
            this.setResponseHeaders(ret, map);
            ObsObjectService.setStatusCode(ret, response.code());
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }
}

