/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.services.internal.ServiceException;
import com.obs.services.internal.service.ObsFileService;
import com.obs.services.internal.utils.JSONChange;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.ReadAheadQueryResult;
import com.obs.services.model.ReadAheadRequest;
import com.obs.services.model.ReadAheadResult;
import com.oef.services.model.CreateAsynchFetchJobsResult;
import com.oef.services.model.DisPolicy;
import com.oef.services.model.GetDisPolicyResult;
import com.oef.services.model.QueryAsynchFetchJobsResult;
import com.oef.services.model.QueryExtensionPolicyResult;
import com.oef.services.model.RequestParamEnum;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Response;

public abstract class ObsExtensionService
extends ObsFileService {
    protected HeaderResponse setExtensionPolicyImpl(String bucketName, String policyDocument) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(RequestParamEnum.EXTENSION_POLICY.getOriginalStringCode(), "");
        return this.performRestPut(bucketName, policyDocument, requestParameters);
    }

    protected QueryExtensionPolicyResult queryExtensionPolicyImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.EXTENSION_POLICY.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        Response response = this.performRestGet(bucketName, requestParams, metadata);
        String body = this.readBodyFromResponse(response);
        QueryExtensionPolicyResult ret = (QueryExtensionPolicyResult)JSONChange.jsonToObj(new QueryExtensionPolicyResult(), body);
        ret.setResponseHeaders(this.cleanResponseHeaders(response));
        ObsExtensionService.setStatusCode(ret, response.code());
        return ret;
    }

    private String readBodyFromResponse(Response response) {
        String body;
        try {
            body = response.body().string();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return body;
    }

    private Response performRestGet(String bucketName, Map<String, String> requestParams, Map<String, String> metadata) {
        metadata.put((this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestGet(bucketName, null, requestParams, metadata, true);
        this.verifyResponseContentTypeForJson(response);
        return response;
    }

    protected HeaderResponse deleteExtensionPolicyImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.EXTENSION_POLICY.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put((this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestDelete(bucketName, null, requestParams, metadata, true, true);
        return this.build(response);
    }

    protected CreateAsynchFetchJobsResult createFetchJobImpl(String bucketName, String policyDocument) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(RequestParamEnum.ASYNC_FETCH_JOBS.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/json");
        metadata.put((this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestPost(bucketName, null, metadata, requestParameters, this.createRequestBody("application/json", policyDocument), false, true);
        this.verifyResponseContentTypeForJson(response);
        String body = this.readBodyFromResponse(response);
        CreateAsynchFetchJobsResult ret = (CreateAsynchFetchJobsResult)JSONChange.jsonToObj(new CreateAsynchFetchJobsResult(), body);
        ret.setResponseHeaders(this.cleanResponseHeaders(response));
        ObsExtensionService.setStatusCode(ret, response.code());
        return ret;
    }

    protected QueryAsynchFetchJobsResult queryFetchJobImpl(String bucketName, String jobId) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.ASYNC_FETCH_JOBS.getOriginalStringCode() + "/" + jobId, "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/json");
        Response response = this.performRestGet(bucketName, requestParams, metadata);
        String body = this.readBodyFromResponse(response);
        QueryAsynchFetchJobsResult ret = (QueryAsynchFetchJobsResult)JSONChange.jsonToObj(new QueryAsynchFetchJobsResult(), body);
        ret.setResponseHeaders(this.cleanResponseHeaders(response));
        ObsExtensionService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse putDisPolicyImpl(String bucketName, String policyDocument) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(RequestParamEnum.DIS_POLICIES.getOriginalStringCode(), "");
        return this.performRestPut(bucketName, policyDocument, requestParameters);
    }

    private HeaderResponse performRestPut(String bucketName, String policyDocument, Map<String, String> requestParameters) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/json");
        metadata.put((this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestPut(bucketName, null, metadata, requestParameters, this.createRequestBody("application/json", policyDocument), false, true);
        HeaderResponse ret = this.build(this.cleanResponseHeaders(response));
        ObsExtensionService.setStatusCode(ret, response.code());
        return ret;
    }

    protected GetDisPolicyResult getDisPolicyImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.DIS_POLICIES.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        Response response = this.performRestGet(bucketName, requestParams, metadata);
        String body = this.readBodyFromResponse(response);
        DisPolicy policy = (DisPolicy)JSONChange.jsonToObj(new DisPolicy(), body);
        GetDisPolicyResult ret = new GetDisPolicyResult(policy);
        ret.setResponseHeaders(this.cleanResponseHeaders(response));
        ObsExtensionService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteDisPolicyImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.DIS_POLICIES.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put((this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestDelete(bucketName, null, requestParams, metadata, true, true);
        return this.build(response);
    }

    protected ReadAheadResult readAheadObjectsImpl(ReadAheadRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("readAhead", "");
        requestParameters.put("prefix", request.getPrefix());
        HashMap<String, String> metadata = new HashMap<String, String>();
        String cacheControl = request.getCacheOption().getCode() + ", ttl=" + request.getTtl();
        metadata.put("x-cache-control", cacheControl);
        Response response = this.performRestPost(request.getBucketName(), null, metadata, requestParameters, null, false);
        this.verifyResponseContentTypeForJson(response);
        String body = this.readBodyFromResponse(response);
        ReadAheadResult result = (ReadAheadResult)JSONChange.jsonToObj(new ReadAheadResult(), body);
        result.setResponseHeaders(this.cleanResponseHeaders(response));
        ObsExtensionService.setStatusCode(result, response.code());
        return result;
    }

    protected ReadAheadResult deleteReadAheadObjectsImpl(String bucketName, String prefix) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("readAhead", "");
        requestParameters.put("prefix", prefix);
        Response response = this.performRestDelete(bucketName, null, requestParameters, false);
        this.verifyResponseContentTypeForJson(response);
        String body = this.readBodyFromResponse(response);
        ReadAheadResult result = (ReadAheadResult)JSONChange.jsonToObj(new ReadAheadResult(), body);
        result.setResponseHeaders(this.cleanResponseHeaders(response));
        ObsExtensionService.setStatusCode(result, response.code());
        return result;
    }

    protected ReadAheadQueryResult queryReadAheadObjectsTaskImpl(String bucketName, String taskId) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("readAhead", "");
        requestParameters.put("taskID", taskId);
        Response response = this.performRestGet(bucketName, null, requestParameters, null);
        this.verifyResponseContentTypeForJson(response);
        String body = this.readBodyFromResponse(response);
        ReadAheadQueryResult result = (ReadAheadQueryResult)JSONChange.jsonToObj(new ReadAheadQueryResult(), body);
        result.setResponseHeaders(this.cleanResponseHeaders(response));
        ObsExtensionService.setStatusCode(result, response.code());
        return result;
    }
}

