/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.IHeaders;
import com.obs.services.internal.RestStorageService;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.AvailableZoneEnum;
import com.obs.services.model.BucketTypeEnum;
import com.obs.services.model.GenericRequest;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.fs.FSStatusEnum;
import com.obs.services.model.fs.GetBucketFSStatusResult;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class AbstractRequestConvertor
extends RestStorageService {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");

    protected Map<String, String> transRequestPaymentHeaders(boolean isRequesterPays, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (isRequesterPays) {
            if (null == headers) {
                headers = new HashMap<String, String>();
            }
            this.putHeader(headers, iheaders.requestPaymentHeader(), "requester");
        }
        return headers;
    }

    protected Map<String, String> transRequestPaymentHeaders(GenericRequest request, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (null != request) {
            return this.transRequestPaymentHeaders(request.isRequesterPays(), headers, iheaders);
        }
        return null;
    }

    protected String getHeaderByMethodName(String code) {
        try {
            IHeaders iheaders = this.getIHeaders();
            Method m = iheaders.getClass().getMethod(code, new Class[0]);
            Object result = m.invoke((Object)iheaders, new Object[0]);
            return result == null ? "" : result.toString();
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn("Invoke getHeaderByMethodName error", e);
            }
            return null;
        }
    }

    protected void putHeader(Map<String, String> headers, String key, String value) {
        if (ServiceUtils.isValid(key)) {
            headers.put(key, value);
        }
    }

    protected HeaderResponse build(Response res) {
        HeaderResponse response = new HeaderResponse();
        this.setResponseHeaders(response, this.cleanResponseHeaders(res));
        AbstractRequestConvertor.setStatusCode(response, res.code());
        return response;
    }

    protected static void setStatusCode(HeaderResponse response, int statusCode) {
        response.setStatusCode(statusCode);
    }

    protected Map<String, Object> cleanResponseHeaders(Response response) {
        Map map = response.headers().toMultimap();
        return ServiceUtils.cleanRestMetadataMap(map, this.getIHeaders().headerPrefix(), this.getIHeaders().headerMetaPrefix());
    }

    protected void setResponseHeaders(HeaderResponse response, Map<String, Object> responseHeaders) {
        response.setResponseHeaders(responseHeaders);
    }

    protected SpecialParamEnum getSpecialParamForStorageClass() {
        return this.getProviderCredentials().getAuthType() == AuthTypeEnum.OBS ? SpecialParamEnum.STORAGECLASS : SpecialParamEnum.STORAGEPOLICY;
    }

    protected HeaderResponse build(Map<String, Object> responseHeaders) {
        HeaderResponse response = new HeaderResponse();
        this.setResponseHeaders(response, responseHeaders);
        return response;
    }

    protected RequestBody createRequestBody(String mimeType, String content) throws ServiceException {
        if (log.isTraceEnabled()) {
            log.trace("Entity Content:" + content);
        }
        return RequestBody.create((MediaType)MediaType.parse((String)mimeType), (byte[])content.getBytes(StandardCharsets.UTF_8));
    }

    protected GetBucketFSStatusResult getOptionInfoResult(Response response) {
        Headers headers = response.headers();
        Map map = headers.toMultimap();
        String maxAge = headers.get("Access-Control-Max-Age");
        IHeaders iheaders = this.getIHeaders();
        FSStatusEnum status = FSStatusEnum.getValueFromCode(headers.get(iheaders.fsFileInterfaceHeader()));
        BucketTypeEnum bucketType = BucketTypeEnum.OBJECT;
        if (FSStatusEnum.ENABLED == status) {
            bucketType = BucketTypeEnum.PFS;
        }
        GetBucketFSStatusResult output = new GetBucketFSStatusResult.Builder().allowOrigin(headers.get("Access-Control-Allow-Origin")).allowHeaders((List)map.get("Access-Control-Allow-Headers")).maxAge(maxAge == null ? 0 : Integer.parseInt(maxAge)).allowMethods((List)map.get("Access-Control-Allow-Methods")).exposeHeaders((List)map.get("Access-Control-Expose-Headers")).storageClass(StorageClassEnum.getValueFromCode(headers.get(iheaders.defaultStorageClassHeader()))).location(headers.get(iheaders.bucketRegionHeader())).obsVersion(headers.get(iheaders.serverVersionHeader())).status(status).availableZone(AvailableZoneEnum.getValueFromCode(headers.get(iheaders.azRedundancyHeader()))).epid(headers.get(iheaders.epidHeader())).bucketType(bucketType).build();
        this.setResponseHeaders(output, this.cleanResponseHeaders(response));
        AbstractRequestConvertor.setStatusCode(output, response.code());
        return output;
    }

    protected AuthTypeEnum getApiVersion(String bucketName) throws ServiceException {
        if (!ServiceUtils.isValid(bucketName)) {
            return this.parseAuthTypeInResponse("");
        }
        AuthTypeEnum apiVersion = this.apiVersionCache.getApiVersionInCache(bucketName);
        if (apiVersion == null) {
            try {
                this.segmentLock.lock(bucketName);
                apiVersion = this.apiVersionCache.getApiVersionInCache(bucketName);
                if (apiVersion == null) {
                    apiVersion = this.parseAuthTypeInResponse(bucketName);
                    this.apiVersionCache.addApiVersion(bucketName, apiVersion);
                }
            }
            finally {
                this.segmentLock.unlock(bucketName);
            }
        }
        return apiVersion;
    }

    protected void verifyResponseContentType(Response response) throws ServiceException {
        String contentType;
        if (this.obsProperties.getBoolProperty("obs.verify-content-type", true) && !"application/xml".equalsIgnoreCase(contentType = response.header("Content-Type")) && !"text/xml".equalsIgnoreCase(contentType)) {
            throw new ServiceException("Expected XML document response from OBS but received content type " + contentType);
        }
    }

    protected void verifyResponseContentTypeForJson(Response response) throws ServiceException {
        if (this.obsProperties.getBoolProperty("obs.verify-content-type", true)) {
            String contentType = response.header("Content-Type");
            if (null == contentType) {
                throw new ServiceException("Expected JSON document response  but received content type is null");
            }
            if (-1 == contentType.indexOf("application/json")) {
                throw new ServiceException("Expected JSON document response  but received content type is " + contentType);
            }
        }
    }

    private AuthTypeEnum parseAuthTypeInResponse(String bucketName) throws ServiceException {
        String apiVersion;
        Response response;
        try {
            response = this.getAuthTypeNegotiationResponseImpl(bucketName);
        }
        catch (ServiceException e) {
            if (e.getResponseCode() == 404 || e.getResponseCode() <= 0 || e.getResponseCode() == 408 || e.getResponseCode() >= 500) {
                throw e;
            }
            return AuthTypeEnum.V2;
        }
        return response.code() == 200 && (apiVersion = response.headers().get("x-obs-api")) != null && apiVersion.compareTo("3.0") >= 0 ? AuthTypeEnum.OBS : AuthTypeEnum.V2;
    }

    private Response getAuthTypeNegotiationResponseImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("apiversion", "");
        return this.performRestForApiVersion(bucketName, null, requestParameters, null);
    }

    protected static class TransResult {
        private Map<String, String> headers;
        private Map<String, String> params;
        private RequestBody body;

        TransResult(Map<String, String> headers) {
            this(headers, null, null);
        }

        TransResult(Map<String, String> headers, RequestBody body) {
            this(headers, null, body);
        }

        TransResult(Map<String, String> headers, Map<String, String> params, RequestBody body) {
            this.headers = headers;
            this.params = params;
            this.body = body;
        }

        public Map<String, String> getHeaders() {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            return this.headers;
        }

        public Map<String, String> getParams() {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            return this.params;
        }

        public void setParams(Map<String, String> params) {
            this.params = params;
        }

        public void setBody(RequestBody body) {
            this.body = body;
        }

        public RequestBody getBody() {
            return this.body;
        }
    }
}

