/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.jamesmurty.utils.BaseXMLBuilder;
import com.jamesmurty.utils.XMLBuilder;
import com.obs.services.internal.IConvertor;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.V2BucketConvertor;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.BucketStoragePolicyConfiguration;
import com.obs.services.model.CanonicalGrantee;
import com.obs.services.model.EventTypeEnum;
import com.obs.services.model.GrantAndPermission;
import com.obs.services.model.GranteeInterface;
import com.obs.services.model.GroupGrantee;
import com.obs.services.model.GroupGranteeEnum;
import com.obs.services.model.KeyAndVersion;
import com.obs.services.model.LifecycleConfiguration;
import com.obs.services.model.Owner;
import com.obs.services.model.PartEtag;
import com.obs.services.model.Permission;
import com.obs.services.model.Redirect;
import com.obs.services.model.ReplicationConfiguration;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.RouteRule;
import com.obs.services.model.RouteRuleCondition;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.WebsiteConfiguration;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class V2Convertor
extends V2BucketConvertor {
    private static IConvertor instance = new V2Convertor();

    protected V2Convertor() {
    }

    public static IConvertor getInstance() {
        return instance;
    }

    @Override
    public String transCompleteMultipartUpload(List<PartEtag> parts) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create((String)"CompleteMultipartUpload");
            Collections.sort(parts, new Comparator<PartEtag>(){

                @Override
                public int compare(PartEtag o1, PartEtag o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return o1.getPartNumber().compareTo(o2.getPartNumber());
                }
            });
            for (PartEtag part : parts) {
                builder.e("Part").e("PartNumber").t(part.getPartNumber() == null ? "" : part.getPartNumber().toString()).up().e("ETag").t(ServiceUtils.toValid(part.getEtag()));
            }
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public String transVersioningConfiguration(String bucketName, String status) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create((String)"VersioningConfiguration").elem("Status").text(ServiceUtils.toValid(status));
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for versioning", e);
        }
    }

    @Override
    public String transRequestPaymentConfiguration(String bucketName, String payer) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create((String)"RequestPaymentConfiguration").elem("Payer").text(ServiceUtils.toValid(payer));
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for requestPayment", e);
        }
    }

    @Override
    public String transLifecycleConfiguration(LifecycleConfiguration config) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create((String)"LifecycleConfiguration");
            for (LifecycleConfiguration.Rule rule : config.getRules()) {
                XMLBuilder b = builder.elem("Rule");
                if (ServiceUtils.isValid2(rule.getId())) {
                    b.elem("ID").t(rule.getId());
                }
                if (rule.getPrefix() != null) {
                    b.elem("Prefix").t(ServiceUtils.toValid(rule.getPrefix()));
                }
                b.elem("Status").t(rule.getEnabled() != false ? "Enabled" : "Disabled");
                if (rule.getTransitions() != null) {
                    this.transTransitions(rule, b);
                }
                if (rule.getExpiration() != null) {
                    this.transExpiration(rule, b);
                }
                if (rule.getNoncurrentVersionTransitions() != null) {
                    this.transNoncurrentVersionTransition(rule, b);
                }
                if (rule.getNoncurrentVersionExpiration() == null || rule.getNoncurrentVersionExpiration().getDays() == null) continue;
                XMLBuilder noncurrentVersionBuilder = b.elem("NoncurrentVersionExpiration");
                noncurrentVersionBuilder.elem("NoncurrentDays").t(rule.getNoncurrentVersionExpiration().getDays().toString());
            }
            return builder.asString();
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException("Failed to build XML document for lifecycle", e);
        }
        catch (TransformerException e) {
            throw new ServiceException("Failed to build XML document for lifecycle", e);
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for lifecycle", e);
        }
    }

    private void transNoncurrentVersionTransition(LifecycleConfiguration.Rule rule, XMLBuilder b) {
        for (LifecycleConfiguration.NoncurrentVersionTransition noncurrentVersionTransition : rule.getNoncurrentVersionTransitions()) {
            if (noncurrentVersionTransition.getObjectStorageClass() == null || noncurrentVersionTransition.getDays() == null) continue;
            XMLBuilder noncurrentVersionBuilder = b.elem("NoncurrentVersionTransition");
            noncurrentVersionBuilder.elem("NoncurrentDays").t(noncurrentVersionTransition.getDays().toString());
            noncurrentVersionBuilder.elem("StorageClass").t(this.transStorageClass(noncurrentVersionTransition.getObjectStorageClass()));
        }
    }

    private void transExpiration(LifecycleConfiguration.Rule rule, XMLBuilder b) {
        XMLBuilder expirationBuilder = b.elem("Expiration");
        if (rule.getExpiration().getDate() != null) {
            expirationBuilder.elem("Date").t(ServiceUtils.formatIso8601MidnightDate(rule.getExpiration().getDate()));
        } else if (rule.getExpiration().getDays() != null) {
            expirationBuilder.elem("Days").t(rule.getExpiration().getDays().toString());
        }
    }

    private void transTransitions(LifecycleConfiguration.Rule rule, XMLBuilder b) {
        for (LifecycleConfiguration.Transition transition : rule.getTransitions()) {
            if (transition.getObjectStorageClass() == null) continue;
            XMLBuilder transitionBuilder = b.elem("Transition");
            if (transition.getDate() != null) {
                transitionBuilder.elem("Date").t(ServiceUtils.formatIso8601MidnightDate(transition.getDate()));
            } else if (transition.getDays() != null) {
                transitionBuilder.elem("Days").t(transition.getDays().toString());
            }
            transitionBuilder.elem("StorageClass").t(this.transStorageClass(transition.getObjectStorageClass()));
        }
    }

    @Override
    public String transWebsiteConfiguration(WebsiteConfiguration config) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create((String)"WebsiteConfiguration");
            if (config.getRedirectAllRequestsTo() != null) {
                if (null != config.getRedirectAllRequestsTo().getHostName()) {
                    builder = builder.elem("RedirectAllRequestsTo").elem("HostName").text(ServiceUtils.toValid(config.getRedirectAllRequestsTo().getHostName()));
                }
                if (null != config.getRedirectAllRequestsTo().getRedirectProtocol()) {
                    builder = builder.up().elem("Protocol").text(config.getRedirectAllRequestsTo().getRedirectProtocol().getCode());
                }
                return builder.asString();
            }
            if (ServiceUtils.isValid2(config.getSuffix())) {
                builder.elem("IndexDocument").elem("Suffix").text(config.getSuffix());
            }
            if (ServiceUtils.isValid2(config.getKey())) {
                builder.elem("ErrorDocument").elem("Key").text(config.getKey());
            }
            if (null != config.getRouteRules() && config.getRouteRules().size() > 0) {
                builder = builder.elem("RoutingRules");
                for (RouteRule routingRule : config.getRouteRules()) {
                    builder = this.transWebsiteRoutingRule(builder, routingRule);
                }
                builder = builder.up();
            }
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for website", e);
        }
    }

    private XMLBuilder transWebsiteRoutingRule(XMLBuilder builder, RouteRule routingRule) {
        Redirect redirect;
        builder = builder.elem("RoutingRule");
        RouteRuleCondition condition = routingRule.getCondition();
        if (null != condition) {
            builder = builder.elem("Condition");
            String keyPrefixEquals = condition.getKeyPrefixEquals();
            String hecre = condition.getHttpErrorCodeReturnedEquals();
            if (ServiceUtils.isValid2(keyPrefixEquals)) {
                builder = builder.elem("KeyPrefixEquals").text(keyPrefixEquals);
                builder = builder.up();
            }
            if (ServiceUtils.isValid2(hecre)) {
                builder = builder.elem("HttpErrorCodeReturnedEquals").text(hecre);
                builder = builder.up();
            }
            builder = builder.up();
        }
        if (null != (redirect = routingRule.getRedirect())) {
            builder = builder.elem("Redirect");
            String hostName = redirect.getHostName();
            String repalceKeyWith = redirect.getReplaceKeyWith();
            String replaceKeyPrefixWith = redirect.getReplaceKeyPrefixWith();
            String redirectCode = redirect.getHttpRedirectCode();
            if (ServiceUtils.isValid2(hostName)) {
                builder = builder.elem("HostName").text(hostName);
                builder = builder.up();
            }
            if (ServiceUtils.isValid2(redirectCode)) {
                builder = builder.elem("HttpRedirectCode").text(redirectCode);
                builder = builder.up();
            }
            if (ServiceUtils.isValid2(repalceKeyWith)) {
                builder = builder.elem("ReplaceKeyWith").text(repalceKeyWith);
                builder = builder.up();
            }
            if (ServiceUtils.isValid2(replaceKeyPrefixWith)) {
                builder = builder.elem("ReplaceKeyPrefixWith").text(replaceKeyPrefixWith);
                builder = builder.up();
            }
            if (redirect.getRedirectProtocol() != null) {
                builder = builder.elem("Protocol").text(redirect.getRedirectProtocol().getCode());
                builder = builder.up();
            }
            builder = builder.up();
        }
        builder = builder.up();
        return builder;
    }

    @Override
    public String transRestoreObjectRequest(RestoreObjectRequest req) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create((String)"RestoreRequest").elem("Days").t(String.valueOf(req.getDays())).up();
            if (req.getRestoreTier() != null) {
                builder.e("GlacierJobParameters").e("Tier").t(req.getRestoreTier().getCode());
            }
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for restoreobject", e);
        }
    }

    @Override
    public String transStoragePolicy(BucketStoragePolicyConfiguration status) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create((String)"StoragePolicy").elem("DefaultStorageClass").text(this.transStorageClass(status.getBucketStorageClass()));
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for StoragePolicy", e);
        }
    }

    @Override
    public String transAccessControlList(AccessControlList acl, boolean isBucket) throws ServiceException {
        Owner owner = acl.getOwner();
        GrantAndPermission[] grants = acl.getGrantAndPermissions();
        try {
            XMLBuilder builder = XMLBuilder.create((String)"AccessControlPolicy");
            if (owner != null) {
                builder = builder.elem("Owner").elem("ID").text(ServiceUtils.toValid(owner.getId()));
                if (null != owner.getDisplayName()) {
                    builder.up().elem("DisplayName").text(owner.getDisplayName());
                }
                builder = builder.up().up();
            }
            if (grants.length > 0) {
                XMLBuilder accessControlList = builder.elem("AccessControlList");
                for (GrantAndPermission gap : grants) {
                    GranteeInterface grantee = gap.getGrantee();
                    Permission permission = gap.getPermission();
                    XMLBuilder subBuilder = null;
                    if (grantee instanceof CanonicalGrantee) {
                        subBuilder = this.buildCanonicalGrantee(grantee);
                    } else if (grantee instanceof GroupGrantee) {
                        subBuilder = this.buildGroupGrantee(grantee);
                    } else if (grantee != null) {
                        subBuilder = XMLBuilder.create((String)"Grantee").attr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").attr("xsi:type", "CanonicalUser").element("ID").text(ServiceUtils.toValid(grantee.getIdentifier()));
                    }
                    if (subBuilder == null) continue;
                    XMLBuilder grantBuilder = accessControlList.elem("Grant").importXMLBuilder((BaseXMLBuilder)subBuilder);
                    if (permission == null) continue;
                    grantBuilder.elem("Permission").text(ServiceUtils.toValid(permission.getPermissionString()));
                }
            }
            return builder.asString();
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException("Failed to build XML document for ACL", e);
        }
        catch (TransformerException e) {
            throw new ServiceException("Failed to build XML document for ACL", e);
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for ACL", e);
        }
    }

    @Override
    public String transKeyAndVersion(KeyAndVersion[] objectNameAndVersions, boolean isQuiet) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create((String)"Delete").elem("Quiet").text(String.valueOf(isQuiet)).up();
            for (KeyAndVersion nav : objectNameAndVersions) {
                XMLBuilder objectBuilder = builder.elem("Object").elem("Key").text(ServiceUtils.toValid(nav.getKey())).up();
                if (!ServiceUtils.isValid(nav.getVersion())) continue;
                objectBuilder.elem("VersionId").text(nav.getVersion());
            }
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document", e);
        }
    }

    @Override
    public String transReplicationConfiguration(ReplicationConfiguration replicationConfiguration) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create((String)"ReplicationConfiguration").e("Agency").t(ServiceUtils.toValid(replicationConfiguration.getAgency())).up();
            for (ReplicationConfiguration.Rule rule : replicationConfiguration.getRules()) {
                builder = builder.e("Rule");
                if (rule.getId() != null) {
                    builder.e("ID").t(rule.getId());
                }
                builder.e("Prefix").t(ServiceUtils.toValid(rule.getPrefix()));
                if (rule.getStatus() != null) {
                    builder.e("Status").t(rule.getStatus().getCode());
                }
                if (rule.getHistoricalObjectReplication() != null) {
                    builder.e("HistoricalObjectReplication").t(rule.getHistoricalObjectReplication().getCode());
                }
                if (rule.getDestination() != null) {
                    String bucketName = ServiceUtils.toValid(rule.getDestination().getBucket());
                    builder = builder.e("Destination").e("Bucket").t(bucketName.startsWith("arn:aws:s3:::") ? bucketName : "arn:aws:s3:::" + bucketName).up();
                    if (rule.getDestination().getObjectStorageClass() != null) {
                        builder.e("StorageClass").t(this.transStorageClass(rule.getDestination().getObjectStorageClass()));
                    }
                    builder = builder.up();
                }
                builder = builder.up();
            }
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for Replication", e);
        }
    }

    @Override
    public String transEventType(EventTypeEnum eventType) {
        String eventTypeStr = "";
        if (eventType != null) {
            switch (eventType) {
                case OBJECT_CREATED_ALL: {
                    eventTypeStr = "s3:ObjectCreated:*";
                    break;
                }
                case OBJECT_CREATED_PUT: {
                    eventTypeStr = "s3:ObjectCreated:Put";
                    break;
                }
                case OBJECT_CREATED_POST: {
                    eventTypeStr = "s3:ObjectCreated:Post";
                    break;
                }
                case OBJECT_CREATED_COPY: {
                    eventTypeStr = "s3:ObjectCreated:Copy";
                    break;
                }
                case OBJECT_CREATED_COMPLETE_MULTIPART_UPLOAD: {
                    eventTypeStr = "s3:ObjectCreated:CompleteMultipartUpload";
                    break;
                }
                case OBJECT_REMOVED_ALL: {
                    eventTypeStr = "s3:ObjectRemoved:*";
                    break;
                }
                case OBJECT_REMOVED_DELETE: {
                    eventTypeStr = "s3:ObjectRemoved:Delete";
                    break;
                }
                case OBJECT_REMOVED_DELETE_MARKER_CREATED: {
                    eventTypeStr = "s3:ObjectRemoved:DeleteMarkerCreated";
                    break;
                }
            }
        }
        return eventTypeStr;
    }

    @Override
    public String transStorageClass(StorageClassEnum storageClass) {
        String storageClassStr = "";
        if (storageClass != null) {
            switch (storageClass) {
                case STANDARD: {
                    storageClassStr = "STANDARD";
                    break;
                }
                case WARM: {
                    storageClassStr = "STANDARD_IA";
                    break;
                }
                case COLD: {
                    storageClassStr = "GLACIER";
                    break;
                }
            }
        }
        return storageClassStr;
    }

    @Override
    public AccessControlList transCannedAcl(String cannedAcl) {
        if ("private".equals(cannedAcl)) {
            return AccessControlList.REST_CANNED_PRIVATE;
        }
        if ("public-read".equals(cannedAcl)) {
            return AccessControlList.REST_CANNED_PUBLIC_READ;
        }
        if ("public-read-write".equals(cannedAcl)) {
            return AccessControlList.REST_CANNED_PUBLIC_READ_WRITE;
        }
        if ("public-read-delivered".equals(cannedAcl)) {
            return AccessControlList.REST_CANNED_PUBLIC_READ;
        }
        if ("public-read-write-delivered".equals(cannedAcl)) {
            return AccessControlList.REST_CANNED_PUBLIC_READ_WRITE;
        }
        if ("authenticated-read".equals(cannedAcl)) {
            return AccessControlList.REST_CANNED_AUTHENTICATED_READ;
        }
        if ("bucket-owner-read".equals(cannedAcl)) {
            return AccessControlList.REST_CANNED_BUCKET_OWNER_READ;
        }
        if ("bucket-owner-full-control".equals(cannedAcl)) {
            return AccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL;
        }
        if ("log-delivery-write".equals(cannedAcl)) {
            return AccessControlList.REST_CANNED_LOG_DELIVERY_WRITE;
        }
        return null;
    }

    @Override
    public String transGroupGrantee(GroupGranteeEnum groupGrantee) {
        String groupGranteeStr = "";
        if (groupGrantee != null) {
            switch (groupGrantee) {
                case ALL_USERS: {
                    groupGranteeStr = "http://acs.amazonaws.com/groups/global/AllUsers";
                    break;
                }
                case AUTHENTICATED_USERS: {
                    groupGranteeStr = "http://acs.amazonaws.com/groups/global/AuthenticatedUsers";
                    break;
                }
                case LOG_DELIVERY: {
                    groupGranteeStr = "http://acs.amazonaws.com/groups/s3/LogDelivery";
                    break;
                }
            }
        }
        return groupGranteeStr;
    }
}

