/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.log.ILogger;
import com.obs.log.InterfaceLogBean;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.Constants;
import com.obs.services.internal.IConvertor;
import com.obs.services.internal.IHeaders;
import com.obs.services.internal.OefExceptionMessage;
import com.obs.services.internal.RestConnectionService;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.consensus.CacheManager;
import com.obs.services.internal.handler.XmlResponsesSaxParser;
import com.obs.services.internal.io.UnrecoverableIOException;
import com.obs.services.internal.security.BasicSecurityKey;
import com.obs.services.internal.security.ProviderCredentialThreadContext;
import com.obs.services.internal.security.ProviderCredentials;
import com.obs.services.internal.utils.IAuthentication;
import com.obs.services.internal.utils.JSONChange;
import com.obs.services.internal.utils.RestUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.internal.utils.V4Authentication;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.HttpMethodEnum;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLException;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class RestStorageService
extends RestConnectionService {
    private static final ILogger log = LoggerBuilder.getLogger(RestStorageService.class);
    private static final Set<Class<? extends IOException>> NON_RETRIABLE_CLASSES = new HashSet<Class<? extends IOException>>();
    private static final String REQUEST_TIMEOUT_CODE = "RequestTimeout";
    private static final String UNEXPECTED_END_OF_STREAM_EXCEPTION = "unexpected end of stream";
    private static ThreadLocal<HashMap<String, String>> userHeaders;
    protected static final ThreadLocal<Boolean> CAN_USE_STANDARD_HTTP_HEADERS;

    protected RestStorageService() {
    }

    public void setCanUseStandardHTTPHeaders(Boolean canUseStandardHTTPHeadersMap) {
        CAN_USE_STANDARD_HTTP_HEADERS.set(canUseStandardHTTPHeadersMap);
    }

    public void setUserHeaders(HashMap<String, String> userHeadersMap) {
        userHeaders.set(userHeadersMap);
    }

    private void addUserHeaderToRequest(Request.Builder builder) {
        Map<String, String> userHeaderMap = this.formatMetadataAndHeader((Map<String, String>)userHeaders.get());
        for (Map.Entry<String, String> entry : userHeaderMap.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
            if (!log.isDebugEnabled()) continue;
            log.debug("Added request header to connection: " + entry.getKey() + "=" + entry.getValue());
        }
    }

    private Map<String, String> formatMetadataAndHeader(Map<String, String> metadataAndHeader) {
        HashMap<String, String> format = new HashMap<String, String>();
        if (metadataAndHeader != null) {
            for (Map.Entry<String, String> entry : metadataAndHeader.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!ServiceUtils.isValid(key)) continue;
                if (!((key = key.trim()).startsWith(this.getRestHeaderPrefix()) || key.startsWith("x-obs-") || Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains(key.toLowerCase(Locale.getDefault())))) {
                    key = this.getRestMetadataPrefix() + key;
                }
                try {
                    if (key.startsWith(this.getRestMetadataPrefix())) {
                        key = RestUtils.uriEncode(key, true);
                    }
                    format.put(key, RestUtils.uriEncode(value == null ? "" : value, true));
                }
                catch (ServiceException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Ignore key:" + key);
                }
            }
        }
        return format;
    }

    protected boolean retryRequest(IOException exception, RetryCounter retryCounter, Request request, Call call) {
        retryCounter.addErrorCount();
        if (retryCounter.getErrorCount() > retryCounter.getRetryMaxCount()) {
            return false;
        }
        if (NON_RETRIABLE_CLASSES.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : NON_RETRIABLE_CLASSES) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        return !call.isCanceled();
    }

    private boolean retryRequestForUnexpectedException(IOException exception, RetryCounter retryCounter, Call call) {
        retryCounter.addErrorCount();
        if (null == exception || retryCounter.getErrorCount() > retryCounter.getRetryMaxCount()) {
            return false;
        }
        if (!exception.getMessage().contains(UNEXPECTED_END_OF_STREAM_EXCEPTION)) {
            return false;
        }
        return !call.isCanceled();
    }

    private ServiceException handleThrowable(Request request, Response response, Call call, Throwable t) {
        ServiceException serviceException = t instanceof ServiceException ? (ServiceException)t : new ServiceException("Request Error: " + t, t);
        serviceException.setRequestHost(request.header("Host"));
        serviceException.setRequestVerb(request.method());
        serviceException.setRequestPath(request.url().toString());
        if (response != null) {
            ServiceUtils.closeStream((Closeable)response);
            serviceException.setResponseCode(response.code());
            serviceException.setResponseStatus(response.message());
            serviceException.setResponseDate(response.header("Date"));
            serviceException.setErrorIndicator(response.header("x-reserved-indicator"));
            serviceException.setResponseHeaders(ServiceUtils.cleanRestMetadataMapV2(this.convertHeadersToMap(response.headers()), this.getRestHeaderPrefix(), this.getRestMetadataPrefix()));
            if (!ServiceUtils.isValid(serviceException.getErrorRequestId())) {
                serviceException.setRequestAndHostIds(response.header(this.getIHeaders().requestIdHeader()), response.header(this.getIHeaders().requestId2Header()));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("exception message.", serviceException);
        }
        if (call != null) {
            call.cancel();
        }
        return serviceException;
    }

    private boolean isLocationHostOnly(String location) {
        boolean isOnlyHost = false;
        URI uri = URI.create(location);
        String path = uri.getPath();
        if (location.indexOf("?") < 0 && (path == null || path.isEmpty() || path.equals("/"))) {
            isOnlyHost = true;
        }
        return isOnlyHost;
    }

    protected Response performRequest(Request request, Map<String, String> requestParameters, String bucketName) throws ServiceException {
        return this.performRequest(request, requestParameters, bucketName, true);
    }

    protected Response performRequestWithoutSignature(Request request, Map<String, String> requestParameters, String bucketName) throws ServiceException {
        return this.performRequest(request, requestParameters, bucketName, false);
    }

    protected Response performRequest(Request request, Map<String, String> requestParameters, String bucketName, boolean doSignature) throws ServiceException {
        return this.performRequest(request, requestParameters, bucketName, doSignature, false);
    }

    protected Response performRequest(Request request, Map<String, String> requestParameters, String bucketName, boolean doSignature, boolean isOEF) throws ServiceException {
        RequestInfo requestInfo = new RequestInfo(request, new InterfaceLogBean("performRequest", "", ""));
        try {
            this.tryRequest(requestParameters, bucketName, doSignature, isOEF, requestInfo);
        }
        catch (Throwable t) {
            ServiceException serviceException = this.handleThrowable(requestInfo.getRequest(), requestInfo.getResponse(), requestInfo.getCall(), t);
            throw serviceException;
        }
        if (log.isInfoEnabled()) {
            requestInfo.getReqBean().setRespTime(new Date());
            requestInfo.getReqBean().setResultCode("0");
            log.info(requestInfo.getReqBean());
        }
        return requestInfo.getResponse();
    }

    private void tryRequest(Map<String, String> requestParameters, String bucketName, boolean doSignature, boolean isOEF, RequestInfo requestInfo) throws Exception {
        requestInfo.setRequest(this.initRequest(requestInfo.getRequest()));
        if (log.isDebugEnabled()) {
            log.debug("Performing " + requestInfo.getRequest().method() + " request for '" + requestInfo.getRequest().url());
            log.debug("Headers: " + requestInfo.getRequest().headers());
        }
        RetryController retryController = new RetryController(new RetryCounter(this.obsProperties.getIntProperty("httpclient.retry-max", 3)), new RetryCounter(this.obsProperties.getIntProperty("httpclient.max-retry-on-unexpected-end-exception", -1)), false);
        while (true) {
            if (!retryController.isWasRecentlyRedirected()) {
                requestInfo.setRequest(this.addBaseHeaders(requestInfo.getRequest(), bucketName, doSignature));
            } else {
                retryController.setWasRecentlyRedirected(false);
            }
            requestInfo.setCall(this.httpClient.newCall(requestInfo.getRequest()));
            requestInfo.setResponse(this.executeRequest(requestInfo.getCall(), requestInfo.getRequest(), retryController));
            if (null == requestInfo.getResponse()) continue;
            int responseCode = requestInfo.getResponse().code();
            requestInfo.getReqBean().setRespParams("[responseCode: " + responseCode + "][request-id: " + requestInfo.getResponse().header(this.getIHeaders().requestIdHeader(), "") + "]");
            String contentType = requestInfo.getResponse().header("Content-Type");
            if (log.isDebugEnabled()) {
                log.debug("Response for '" + requestInfo.getRequest().method() + "'. Content-Type: " + contentType + ", ResponseCode:" + responseCode + ", Headers: " + requestInfo.getResponse().headers());
            }
            if (log.isTraceEnabled() && requestInfo.getResponse().body() != null) {
                log.trace("Entity length: " + requestInfo.getResponse().body().contentLength());
            }
            if (isOEF && "application/json".equalsIgnoreCase(contentType)) {
                this.transOEFResponse(requestInfo.getResponse(), requestInfo.getReqBean(), retryController.getErrorRetryCounter().getErrorCount(), responseCode);
                break;
            }
            if (responseCode >= 300 && responseCode < 400 && responseCode != 304) {
                requestInfo.setRequest(this.handleRedirectResponse(requestInfo.getRequest(), requestParameters, bucketName, doSignature, isOEF, requestInfo.getReqBean(), requestInfo.getResponse(), retryController));
                continue;
            }
            if (responseCode >= 400 && responseCode < 500 || responseCode == 304) {
                this.handleRequestErrorResponse(requestInfo.getResponse(), retryController);
                continue;
            }
            if (responseCode < 500) break;
            this.handleServerErrorResponse(requestInfo.getReqBean(), requestInfo.getResponse(), retryController, responseCode);
        }
    }

    private void handleRequestErrorResponse(Response response, RetryController retryController) {
        ServiceException exception = this.createServiceException("Request Error.", response);
        if (!REQUEST_TIMEOUT_CODE.equals(exception.getErrorCode())) {
            throw exception;
        }
        retryController.getErrorRetryCounter().addErrorCount();
        if (retryController.getErrorRetryCounter().getErrorCount() < retryController.getErrorRetryCounter().getRetryMaxCount()) {
            if (log.isWarnEnabled()) {
                log.warn("Retrying connection that failed with RequestTimeout error, attempt number " + retryController.getErrorRetryCounter().getErrorCount() + " of " + retryController.getErrorRetryCounter().getRetryMaxCount());
            }
            return;
        }
        if (log.isErrorEnabled()) {
            log.error("Exceeded maximum number of retries for RequestTimeout errors: " + retryController.getErrorRetryCounter().getRetryMaxCount());
        }
        throw exception;
    }

    private void handleServerErrorResponse(InterfaceLogBean reqBean, Response response, RetryController retryController, int responseCode) {
        reqBean.setResponseInfo("Internal Server error(s).", String.valueOf(responseCode));
        if (log.isErrorEnabled()) {
            log.error(reqBean);
        }
        this.doRetry(response, "Encountered too many 5xx errors (" + retryController.getErrorRetryCounter().getErrorCount() + "), aborting request.", retryController.getErrorRetryCounter());
        this.sleepBeforeRetry(retryController.getErrorRetryCounter().getErrorCount());
    }

    private Request handleRedirectResponse(Request request, Map<String, String> requestParameters, String bucketName, boolean doSignature, boolean isOEF, InterfaceLogBean reqBean, Response response, RetryController retryController) {
        int responseCode = response.code();
        String location = response.header("Location");
        if (!ServiceUtils.isValid(location)) {
            ServiceException exception = new ServiceException("Try to redirect, but location is null!");
            reqBean.setResponseInfo("Request Error:" + exception.getMessage(), "|" + responseCode + "|" + response.message() + "|");
            throw exception;
        }
        request = this.createRedirectRequest(request, requestParameters, bucketName, doSignature, isOEF, responseCode, location);
        retryController.setWasRecentlyRedirected(true);
        this.doRetry(response, "Exceeded 3xx redirect limit (" + retryController.getErrorRetryCounter().getRetryMaxCount() + ").", retryController.getErrorRetryCounter());
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response executeRequest(Call call, Request request, RetryController retryController) throws Exception {
        long start = System.currentTimeMillis();
        try {
            this.semaphore.acquire();
            Response response = call.execute();
            return response;
        }
        catch (IOException e) {
            if (e instanceof UnrecoverableIOException) {
                if (retryController.getLastException() != null) {
                    throw retryController.getLastException();
                }
                throw e;
            }
            retryController.setLastException(e);
            this.retryOnIOException(e, request, retryController, call);
            if (log.isWarnEnabled()) {
                log.warn("Retrying connection that failed with error, attempt number " + retryController.getErrorRetryCounter().getErrorCount() + " of " + retryController.getErrorRetryCounter().getRetryMaxCount());
            }
            Response response = null;
            return response;
        }
        finally {
            this.semaphore.release();
            if (log.isInfoEnabled()) {
                log.info("OkHttp cost " + (System.currentTimeMillis() - start) + " ms to apply http request");
            }
        }
    }

    private void retryOnIOException(IOException e, Request request, RetryController retryController, Call call) throws Exception {
        if (this.retryRequestForUnexpectedException(e, retryController.getUnexpectedErrorRetryCounter(), call)) {
            if (log.isErrorEnabled()) {
                log.error("unexpected end of stream excepiton.");
            }
            return;
        }
        if (this.retryRequest(e, retryController.getErrorRetryCounter(), request, call)) {
            this.sleepBeforeRetry(retryController.getErrorRetryCounter().getErrorCount());
            return;
        }
        if (e instanceof ConnectException || e instanceof InterruptedIOException) {
            ServiceException se = new ServiceException("Request error. ", e);
            se.setResponseCode(408);
            se.setErrorCode("RequestTimeOut");
            se.setErrorMessage(e.getMessage());
            se.setResponseStatus("Request error. ");
            throw se;
        }
        throw e;
    }

    private void doRetry(Response response, String message, RetryCounter retryCounter) {
        retryCounter.addErrorCount();
        if (retryCounter.getErrorCount() > retryCounter.getRetryMaxCount()) {
            throw this.createServiceException(message, response);
        }
        ServiceUtils.closeStream((Closeable)response);
    }

    private ServiceException createServiceException(String message, Response response) {
        String xmlMessage = this.readResponseMessage(response);
        ServiceException exception = new ServiceException(message, xmlMessage);
        return exception;
    }

    private String readResponseMessage(Response response) {
        String xmlMessage = null;
        try {
            if (response.body() != null) {
                xmlMessage = response.body().string();
            }
        }
        catch (IOException e) {
            log.warn("read response body failed.", e);
        }
        return xmlMessage;
    }

    private Request createRedirectRequest(Request request, Map<String, String> requestParameters, String bucketName, boolean doSignature, boolean isOEF, int responseCode, String location) {
        if (location.indexOf("?") < 0) {
            location = this.addRequestParametersToUrlPath(location, requestParameters, isOEF);
        }
        if (doSignature && this.isLocationHostOnly(location)) {
            request = this.authorizeHttpRequest(request, bucketName, location);
        } else {
            Request.Builder builder = request.newBuilder();
            if (responseCode == 302 && HttpMethodEnum.GET.getOperationType().equalsIgnoreCase(request.method())) {
                Headers headers = request.headers().newBuilder().removeAll("Authorization").build();
                builder.headers(headers);
            }
            this.setHost(builder, request, location);
            request = builder.build();
        }
        return request;
    }

    private void transOEFResponse(Response response, InterfaceLogBean reqBean, int internalErrorCount, int responseCode) {
        if (responseCode >= 400 && responseCode < 500) {
            String xmlMessage = this.readResponseMessage(response);
            OefExceptionMessage oefException = (OefExceptionMessage)JSONChange.jsonToObj(new OefExceptionMessage(), ServiceUtils.toValid(xmlMessage));
            ServiceException exception = new ServiceException("Request Error." + ServiceUtils.toValid(xmlMessage));
            exception.setErrorMessage(oefException.getMessage());
            exception.setErrorCode(oefException.getCode());
            exception.setErrorRequestId(oefException.getRequestId());
            throw exception;
        }
        if (responseCode >= 500) {
            reqBean.setResponseInfo("Internal Server error(s).", String.valueOf(responseCode));
            if (log.isErrorEnabled()) {
                log.error(reqBean);
            }
            throw this.createServiceException("Encountered too many 5xx errors (" + internalErrorCount + "), aborting request.", response);
        }
    }

    private Request addBaseHeaders(Request request, String bucketName, boolean doSignature) {
        if (doSignature) {
            request = this.authorizeHttpRequest(request, bucketName, null);
        } else {
            Request.Builder builder = request.newBuilder();
            builder.headers(request.headers().newBuilder().removeAll("Authorization").build());
            this.setHost(builder, request, null);
            builder.header("User-Agent", "obs-sdk-java/3.21.4");
            request = builder.build();
        }
        return request;
    }

    private Request initRequest(Request request) {
        if (userHeaders.get() != null && userHeaders.get().size() > 0) {
            Request.Builder builderTmp = request.newBuilder();
            this.addUserHeaderToRequest(builderTmp);
            request = builderTmp.build();
        }
        return request;
    }

    protected String getRestMetadataPrefix() {
        return this.getIHeaders().headerMetaPrefix();
    }

    protected String getRestHeaderPrefix() {
        return this.getIHeaders().headerPrefix();
    }

    private boolean isProviderCredentialsInValid(ProviderCredentials providerCredentials) {
        return providerCredentials == null || providerCredentials.getObsCredentialsProvider().getSecurityKey() == null || !ServiceUtils.isValid(providerCredentials.getSecurityKey().getAccessKey()) || !ServiceUtils.isValid(providerCredentials.getSecurityKey().getSecretKey());
    }

    private URI setHost(Request.Builder builder, Request request, String url) {
        int insecurePort;
        int securePort;
        URI uri;
        if (url == null) {
            uri = request.url().uri();
        } else {
            uri = URI.create(url);
            builder.url(url);
        }
        String portStr = this.getHttpsOnly() ? ((securePort = this.getHttpsPort()) == 443 ? "" : ":" + securePort) : ((insecurePort = this.getHttpPort()) == 80 ? "" : ":" + insecurePort);
        builder.header("Host", uri.getHost() + portStr);
        return uri;
    }

    private Date parseDate(Request request, boolean isV4) {
        String dateHeader = this.getIHeaders().dateHeader();
        String date = request.header(dateHeader);
        if (date != null) {
            try {
                return isV4 ? ServiceUtils.getLongDateFormat().parse(date) : ServiceUtils.parseRfc822Date(date);
            }
            catch (ParseException e) {
                throw new ServiceException(dateHeader + " is not well-format", e);
            }
        }
        return new Date();
    }

    protected Request authorizeHttpRequest(Request request, String bucketName, String url) throws ServiceException {
        IAuthentication iauthentication;
        String queryString;
        Headers headers = request.headers().newBuilder().removeAll("Authorization").build();
        Request.Builder builder = request.newBuilder();
        builder.headers(headers);
        URI uri = this.setHost(builder, request, url);
        String hostname = uri.getHost();
        ProviderCredentials providerCredentials = ProviderCredentialThreadContext.getInstance().getProviderCredentials();
        if (this.isProviderCredentialsInValid(providerCredentials)) {
            providerCredentials = this.getProviderCredentials();
        } else {
            providerCredentials.setAuthType(this.getProviderCredentials().getAuthType());
        }
        if (this.isProviderCredentialsInValid(providerCredentials)) {
            if (log.isInfoEnabled()) {
                log.info("Service has no Credential and is un-authenticated, skipping authorization");
            }
            return request;
        }
        boolean isV4 = providerCredentials.getAuthType() == AuthTypeEnum.V4;
        Date now = this.parseDate(request, isV4);
        builder.header("Date", ServiceUtils.formatRfc822Date(now));
        BasicSecurityKey securityKey = providerCredentials.getSecurityKey();
        String securityToken = securityKey.getSecurityToken();
        if (ServiceUtils.isValid(securityToken)) {
            builder.header(this.getIHeaders().securityTokenHeader(), securityToken);
        }
        String fullUrl = uri.getRawPath();
        String endpoint = this.getEndpoint();
        if (!(this.isPathStyle() && !this.isCname() || hostname == null || isV4)) {
            if (this.isCname()) {
                fullUrl = "/" + hostname + fullUrl;
            } else if (ServiceUtils.isValid(bucketName) && !endpoint.equals(hostname) && hostname.indexOf(bucketName) >= 0) {
                fullUrl = "/" + bucketName + fullUrl;
            }
        }
        if ((queryString = uri.getRawQuery()) != null && queryString.length() > 0) {
            fullUrl = fullUrl + "?" + queryString;
        }
        if (log.isDebugEnabled()) {
            log.debug("For creating canonical string, using uri: " + fullUrl);
        }
        if (isV4) {
            builder.header(this.getIHeaders().contentSha256Header(), "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
            iauthentication = V4Authentication.makeServiceCanonicalString(request.method(), this.convertHeadersToMap(builder.build().headers()), fullUrl, providerCredentials, now, securityKey);
            if (log.isDebugEnabled()) {
                log.debug("CanonicalRequest:" + iauthentication.getCanonicalRequest());
            }
        } else {
            iauthentication = Constants.AUTHTICATION_MAP.get((Object)providerCredentials.getAuthType()).makeAuthorizationString(request.method(), this.convertHeadersToMap(builder.build().headers()), fullUrl, Constants.ALLOWED_RESOURCE_PARAMTER_NAMES, securityKey);
        }
        String authorizationString = iauthentication.getAuthorization();
        builder.header("Authorization", authorizationString);
        builder.header("User-Agent", "obs-sdk-java/3.21.4");
        return builder.build();
    }

    protected Response performRestHead(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.HEAD, bucketName, objectKey, requestParameters, null);
        this.addRequestHeadersToConnection(builder, requestHeaders);
        return this.performRequest(builder.build(), requestParameters, bucketName);
    }

    protected Response performRestGet(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders) throws ServiceException {
        return this.performRestGet(bucketName, objectKey, requestParameters, requestHeaders, false);
    }

    protected Response performRestGetForListBuckets(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.GET, bucketName, objectKey, requestParameters, null, false, true);
        this.addRequestHeadersToConnection(builder, requestHeaders);
        return this.performRequest(builder.build(), requestParameters, bucketName, true, false);
    }

    protected Response performRestGet(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders, boolean isOEF) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.GET, bucketName, objectKey, requestParameters, null, isOEF);
        this.addRequestHeadersToConnection(builder, requestHeaders);
        return this.performRequest(builder.build(), requestParameters, bucketName, true, isOEF);
    }

    protected Response performRestPut(String bucketName, String objectKey, Map<String, String> metadata, Map<String, String> requestParameters, RequestBody body, boolean autoRelease) throws ServiceException {
        return this.performRestPut(bucketName, objectKey, metadata, requestParameters, body, autoRelease, false);
    }

    protected Response performRestPut(String bucketName, String objectKey, Map<String, String> metadata, Map<String, String> requestParameters, RequestBody body, boolean autoRelease, boolean isOEF) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.PUT, bucketName, objectKey, requestParameters, body, isOEF);
        this.renameMetadataKeys(builder, metadata);
        Response result = this.performRequest(builder.build(), requestParameters, bucketName, true, isOEF);
        if (autoRelease) {
            result.close();
        }
        return result;
    }

    protected Response performRestPost(String bucketName, String objectKey, Map<String, String> metadata, Map<String, String> requestParameters, RequestBody body, boolean autoRelease) throws ServiceException {
        return this.performRestPost(bucketName, objectKey, metadata, requestParameters, body, autoRelease, false);
    }

    protected Response performRestPost(String bucketName, String objectKey, Map<String, String> metadata, Map<String, String> requestParameters, RequestBody body, boolean autoRelease, boolean isOEF) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.POST, bucketName, objectKey, requestParameters, body, isOEF);
        this.renameMetadataKeys(builder, metadata);
        Response result = this.performRequest(builder.build(), requestParameters, bucketName, true, isOEF);
        if (autoRelease) {
            result.close();
        }
        return result;
    }

    protected Response performRestDelete(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> metadata) throws ServiceException {
        return this.performRestDelete(bucketName, objectKey, requestParameters, metadata, true, false);
    }

    protected Response performRestDelete(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> metadata, boolean autoRelease, boolean isOEF) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.DELETE, bucketName, objectKey, requestParameters, null, isOEF);
        this.renameMetadataKeys(builder, metadata);
        Response result = this.performRequest(builder.build(), requestParameters, bucketName, true, isOEF);
        if (autoRelease) {
            result.close();
        }
        return result;
    }

    protected Response performRestDelete(String bucketName, String objectKey, Map<String, String> requestParameters) throws ServiceException {
        return this.performRestDelete(bucketName, objectKey, requestParameters, true);
    }

    protected Response performRestDelete(String bucketName, String objectKey, Map<String, String> requestParameters, boolean autoRelease) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.DELETE, bucketName, objectKey, requestParameters, null);
        Response result = this.performRequest(builder.build(), requestParameters, bucketName);
        if (autoRelease) {
            result.close();
        }
        return result;
    }

    protected Response performRestOptions(String bucketName, String objectKey, Map<String, String> metadata, Map<String, String> requestParameters, boolean autoRelease) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.OPTIONS, bucketName, objectKey, requestParameters, null);
        this.addRequestHeadersToConnection(builder, metadata);
        Response result = this.performRequest(builder.build(), requestParameters, bucketName);
        if (autoRelease) {
            result.close();
        }
        return result;
    }

    protected Response performRestForApiVersion(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders) throws ServiceException {
        Request.Builder builder = null;
        builder = null != bucketName && !"".equals(bucketName.trim()) ? this.setupConnection(HttpMethodEnum.HEAD, bucketName, objectKey, requestParameters, null, false, false) : this.setupConnection(HttpMethodEnum.HEAD, bucketName, objectKey, requestParameters, null, false, true);
        this.addRequestHeadersToConnection(builder, requestHeaders);
        return this.performRequestWithoutSignature(builder.build(), requestParameters, bucketName);
    }

    private void sleepBeforeRetry(int internalErrorCount) {
        long delayMs = 50L * (long)((int)Math.pow(2.0, internalErrorCount));
        if (log.isWarnEnabled()) {
            log.warn("Encountered " + internalErrorCount + " Internal Server error(s), will retry in " + delayMs + "ms");
        }
        try {
            Thread.sleep(delayMs);
        }
        catch (InterruptedException e) {
            log.warn("thread sleep failed.", e);
        }
    }

    protected Map<String, String> convertHeadersToMap(Headers headers) {
        IdentityHashMap<String, String> map = new IdentityHashMap<String, String>();
        for (Map.Entry entry : headers.toMultimap().entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                map.put((String)entry.getKey(), value);
            }
        }
        return map;
    }

    protected ProviderCredentials getProviderCredentials() {
        return this.credentials;
    }

    protected void setProviderCredentials(ProviderCredentials credentials) {
        this.credentials = credentials;
    }

    protected void renameMetadataKeys(Request.Builder builder, Map<String, String> metadata) {
        Map<String, String> convertedMetadata = this.formatMetadataAndHeader(metadata);
        for (Map.Entry<String, String> entry : convertedMetadata.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
            if (!log.isDebugEnabled()) continue;
            log.debug("Added metadata to connection: " + entry.getKey() + "=" + entry.getValue());
        }
    }

    protected XmlResponsesSaxParser getXmlResponseSaxParser() throws ServiceException {
        return new XmlResponsesSaxParser();
    }

    protected void addRequestHeadersToConnection(Request.Builder builder, Map<String, String> requestHeaders) {
        if (requestHeaders != null) {
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!ServiceUtils.isValid(key) || value == null || !Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains((key = key.trim()).toLowerCase(Locale.getDefault())) && !key.startsWith(this.getRestHeaderPrefix())) continue;
                builder.addHeader(key, value);
                if (!log.isDebugEnabled()) continue;
                log.debug("Added request header to connection: " + key + "=" + value);
            }
        }
    }

    protected IHeaders getIHeaders() {
        return Constants.HEADERS_MAP.get((Object)this.getProviderCredentials().getAuthType());
    }

    protected IConvertor getIConvertor() {
        return Constants.CONVERTOR_MAP.get((Object)this.getProviderCredentials().getAuthType());
    }

    protected boolean isAuthTypeNegotiation() {
        return this.obsProperties.getBoolProperty("httpclient.auth-type-negotiation", true);
    }

    protected CacheManager getApiVersionCache() {
        return this.apiVersionCache;
    }

    protected String getFileSystemDelimiter() {
        return this.obsProperties.getStringProperty("filesystem.delimiter", "/");
    }

    static {
        NON_RETRIABLE_CLASSES.add(UnknownHostException.class);
        NON_RETRIABLE_CLASSES.add(SSLException.class);
        NON_RETRIABLE_CLASSES.add(ConnectException.class);
        userHeaders = new ThreadLocal();
        CAN_USE_STANDARD_HTTP_HEADERS = new ThreadLocal();
    }

    private static final class RequestInfo {
        private Request request = null;
        private Response response = null;
        private Call call = null;
        private InterfaceLogBean reqBean;

        public RequestInfo(Request request, InterfaceLogBean reqBean) {
            this.request = request;
            this.reqBean = reqBean;
        }

        public Request getRequest() {
            return this.request;
        }

        public void setRequest(Request request) {
            this.request = request;
        }

        public Response getResponse() {
            return this.response;
        }

        public void setResponse(Response response) {
            this.response = response;
        }

        public Call getCall() {
            return this.call;
        }

        public void setCall(Call call) {
            this.call = call;
        }

        public InterfaceLogBean getReqBean() {
            return this.reqBean;
        }
    }

    private static final class RetryController {
        private RetryCounter errorRetryCounter = null;
        private RetryCounter unexpectedErrorRetryCounter = null;
        private Exception lastException = null;
        private boolean wasRecentlyRedirected = false;

        public RetryController(RetryCounter errorRetryCounter, RetryCounter unexpectedErrorRetryCounter, boolean wasRecentlyRedirected) {
            this.errorRetryCounter = errorRetryCounter;
            this.unexpectedErrorRetryCounter = unexpectedErrorRetryCounter;
            this.wasRecentlyRedirected = wasRecentlyRedirected;
        }

        public Exception getLastException() {
            return this.lastException;
        }

        public void setLastException(Exception lastException) {
            this.lastException = lastException;
        }

        public RetryCounter getErrorRetryCounter() {
            return this.errorRetryCounter;
        }

        public RetryCounter getUnexpectedErrorRetryCounter() {
            return this.unexpectedErrorRetryCounter;
        }

        public boolean isWasRecentlyRedirected() {
            return this.wasRecentlyRedirected;
        }

        public void setWasRecentlyRedirected(boolean wasRecentlyRedirected) {
            this.wasRecentlyRedirected = wasRecentlyRedirected;
        }
    }

    private static final class RetryCounter {
        private int errorCount = 0;
        private int retryMaxCount = 0;

        public RetryCounter(int retryMaxCount) {
            this.retryMaxCount = retryMaxCount;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public void addErrorCount() {
            ++this.errorCount;
        }

        public int getRetryMaxCount() {
            return this.retryMaxCount;
        }
    }
}

