/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.task;

import com.obs.services.ObsClient;
import com.obs.services.internal.task.AbstractObsTask;
import com.obs.services.internal.task.DefaultTaskProgressStatus;
import com.obs.services.model.DeleteObjectRequest;
import com.obs.services.model.DeleteObjectResult;
import com.obs.services.model.TaskCallback;
import com.obs.services.model.TaskProgressListener;

public class DropFolderTask
extends AbstractObsTask {
    private String objectKey;
    private TaskCallback<DeleteObjectResult, String> callback;
    boolean isRequesterPays;

    public DropFolderTask(ObsClient obsClient, String bucketName) {
        super(obsClient, bucketName);
    }

    public DropFolderTask(ObsClient obsClient, String bucketName, String objectKey, DefaultTaskProgressStatus progressStatus, TaskProgressListener progressListener, int taskProgressInterval, TaskCallback<DeleteObjectResult, String> callback, boolean isRequesterPays) {
        super(obsClient, bucketName, progressStatus, progressListener, taskProgressInterval);
        this.objectKey = objectKey;
        this.callback = callback;
        this.isRequesterPays = isRequesterPays;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public void setObjeceKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public TaskCallback<DeleteObjectResult, String> getCallback() {
        return this.callback;
    }

    public void setCallback(TaskCallback<DeleteObjectResult, String> callback) {
        this.callback = callback;
    }

    private void dropFolder() {
        DeleteObjectRequest request = new DeleteObjectRequest(this.bucketName, this.objectKey);
        request.setRequesterPays(this.isRequesterPays);
        DeleteObjectResult result = this.obsClient.deleteObject(request);
        this.progressStatus.succeedTaskIncrement();
        this.callback.onSuccess(result);
    }

    @Override
    public void run() {
        this.dropFolder();
    }
}

