/*
 * Decompiled with CFR 0.152.
 */
package com.homeaway.devtools.jenkins.testing;

import hudson.Extension;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APipelineExtensionDetector {
    private static final Logger LOG = LoggerFactory.getLogger(APipelineExtensionDetector.class);

    public abstract Set<Class<?>> getClassesOfTypeInPackage(Class<?> var1, Optional<String> var2);

    public abstract Set<Class<?>> getClassesWithAnnotationOfTypeInPackage(Class<? extends Annotation> var1, Class<?> var2, Optional<String> var3);

    public Set<String> getPipelineSteps(Optional<String> _package) {
        HashSet<String> names = new HashSet<String>();
        HashMap<String, ReflectiveOperationException> failures = new HashMap<String, ReflectiveOperationException>();
        for (Class<?> clazz : this.getClassesWithAnnotationOfTypeInPackage(Extension.class, StepDescriptor.class, _package)) {
            try {
                StepDescriptor descriptor = (StepDescriptor)clazz.newInstance();
                names.add(descriptor.getFunctionName());
            }
            catch (InstantiationException e) {
                failures.put(clazz.getName(), e);
            }
            catch (IllegalAccessException e) {
                failures.put(clazz.getName(), e);
            }
        }
        if (failures.size() > 0) {
            if ("true".equals(System.getProperty("PipelineExtensionDetector.expandFailures"))) {
                for (Map.Entry entry : failures.entrySet()) {
                    LOG.error((String)entry.getKey(), (Throwable)entry.getValue());
                }
            } else {
                LOG.error("Failed to get the function names of the following StepDescriptor classes. For detailed error messages, set the system property PipelineExtensionDetector.expandFailures=true. Failures: [{}]", failures.keySet());
            }
        }
        return names;
    }

    public Set<String> getGlobalVariables(Optional<String> _package) {
        HashSet<String> names = new HashSet<String>();
        HashMap<String, ReflectiveOperationException> failures = new HashMap<String, ReflectiveOperationException>();
        for (Class<?> clazz : this.getClassesWithAnnotationOfTypeInPackage(Extension.class, GlobalVariable.class, _package)) {
            try {
                GlobalVariable variable = (GlobalVariable)clazz.newInstance();
                names.add(variable.getName());
            }
            catch (InstantiationException e) {
                failures.put(clazz.getName(), e);
            }
            catch (IllegalAccessException e) {
                failures.put(clazz.getName(), e);
            }
        }
        if (failures.size() > 0) {
            if ("true".equals(System.getProperty("PipelineExtensionDetector.expandFailures"))) {
                for (Map.Entry entry : failures.entrySet()) {
                    LOG.error((String)entry.getKey(), (Throwable)entry.getValue());
                }
            } else {
                LOG.error("Failed to get the names of the following GlobalVariable classes. For detailed error messages, set the system property PipelineExtensionDetector.expandFailures=true. Failures: [{}]", failures.keySet());
            }
        }
        return names;
    }

    public Set<String> getSymbols(Optional<String> _package) {
        HashSet<String> names = new HashSet<String>();
        for (Class<?> symbol_class : this.getClassesWithAnnotationOfTypeInPackage(Symbol.class, Object.class, _package)) {
            Symbol symbol = symbol_class.getAnnotation(Symbol.class);
            names.addAll(Arrays.asList(symbol.value()));
        }
        return names;
    }

    public Set<String> getPipelineExtensions(Optional<String> _package) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.getPipelineSteps(_package));
        names.addAll(this.getGlobalVariables(_package));
        names.addAll(this.getSymbols(_package));
        return names;
    }
}

