/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.subscribe;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.handler.subscribe.MqttSubOrUnsubAckFlow;
import com.hivemq.client.internal.mqtt.handler.subscribe.MqttSubscriptionHandler;
import com.hivemq.client.internal.mqtt.ioc.ClientComponent;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.suback.Mqtt5SubAck;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import org.jetbrains.annotations.NotNull;

public class MqttSubAckSingle
extends Single<Mqtt5SubAck> {
    @NotNull
    private final MqttSubscribe subscribe;
    @NotNull
    private final MqttClientConfig clientConfig;

    public MqttSubAckSingle(@NotNull MqttSubscribe subscribe, @NotNull MqttClientConfig clientConfig) {
        this.subscribe = subscribe;
        this.clientConfig = clientConfig;
    }

    protected void subscribeActual(@NotNull SingleObserver<? super Mqtt5SubAck> observer) {
        ClientComponent clientComponent = this.clientConfig.getClientComponent();
        MqttSubscriptionHandler subscriptionHandler = clientComponent.subscriptionHandler();
        MqttSubOrUnsubAckFlow<? super Mqtt5SubAck> flow = new MqttSubOrUnsubAckFlow<Mqtt5SubAck>(observer, this.clientConfig);
        observer.onSubscribe(flow);
        subscriptionHandler.subscribe(this.subscribe, flow);
    }
}

