/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.userauth.keyprovider;

import java.io.BufferedReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.schmizz.sshj.common.Base64;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.userauth.keyprovider.BaseFileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.KeyFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSSHKeyV1KeyFile
extends BaseFileKeyProvider {
    private static final Logger logger = LoggerFactory.getLogger(OpenSSHKeyV1KeyFile.class);
    private static final String BEGIN = "-----BEGIN ";
    private static final String END = "-----END ";
    private static final byte[] AUTH_MAGIC = "openssh-key-v1\u0000".getBytes();
    public static final String OPENSSH_PRIVATE_KEY = "OPENSSH PRIVATE KEY-----";

    @Override
    protected KeyPair readKeyPair() throws IOException {
        KeyPair keyPair;
        BufferedReader reader = new BufferedReader(this.resource.getReader());
        try {
            if (!this.checkHeader(reader)) {
                throw new IOException("This key is not in 'openssh-key-v1' format");
            }
            String keyFile = this.readKeyFile(reader);
            byte[] decode = Base64.decode(keyFile);
            Buffer.PlainBuffer keyBuffer = new Buffer.PlainBuffer(decode);
            keyPair = this.readDecodedKeyPair(keyBuffer);
        }
        catch (GeneralSecurityException e) {
            try {
                throw new SSHRuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        return keyPair;
    }

    private KeyPair readDecodedKeyPair(Buffer.PlainBuffer keyBuffer) throws IOException, GeneralSecurityException {
        byte[] bytes = new byte[AUTH_MAGIC.length];
        keyBuffer.readRawBytes(bytes);
        if (!ByteArrayUtils.equals(bytes, 0, AUTH_MAGIC, 0, AUTH_MAGIC.length)) {
            throw new IOException("This key does not contain the 'openssh-key-v1' format magic header");
        }
        String cipherName = keyBuffer.readString();
        String kdfName = keyBuffer.readString();
        String kdfOptions = keyBuffer.readString();
        int nrKeys = keyBuffer.readUInt32AsInt();
        if (nrKeys != 1) {
            throw new IOException("We don't support having more than 1 key in the file (yet).");
        }
        PublicKey publicKey = this.readPublicKey(new Buffer.PlainBuffer(keyBuffer.readBytes()));
        Buffer.PlainBuffer privateKeyBuffer = new Buffer.PlainBuffer(keyBuffer.readBytes());
        if ("none".equals(cipherName)) {
            logger.debug("Reading unencrypted keypair");
            return this.readUnencrypted(privateKeyBuffer, publicKey);
        }
        logger.info("Keypair is encrypted with: " + cipherName + ", " + kdfName + ", " + kdfOptions);
        throw new IOException("Cannot read encrypted keypair with " + cipherName + " yet.");
    }

    private PublicKey readPublicKey(Buffer.PlainBuffer plainBuffer) throws Buffer.BufferException, GeneralSecurityException {
        return KeyType.fromString(plainBuffer.readString()).readPubKeyFromBuffer(plainBuffer);
    }

    private String readKeyFile(BufferedReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        String line = reader.readLine();
        while (!line.startsWith(END)) {
            sb.append(line);
            line = reader.readLine();
        }
        return sb.toString();
    }

    private boolean checkHeader(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null && !line.startsWith(BEGIN)) {
            line = reader.readLine();
        }
        line = line.substring(BEGIN.length());
        return line.startsWith(OPENSSH_PRIVATE_KEY);
    }

    private KeyPair readUnencrypted(Buffer.PlainBuffer keyBuffer, PublicKey publicKey) throws IOException, GeneralSecurityException {
        int checkInt2;
        int privKeyListSize = keyBuffer.available();
        if (privKeyListSize % 8 != 0) {
            throw new IOException("The private key section must be a multiple of the block size (8)");
        }
        int checkInt1 = keyBuffer.readUInt32AsInt();
        if (checkInt1 != (checkInt2 = keyBuffer.readUInt32AsInt())) {
            throw new IOException("The checkInts differed, the key was not correctly decoded.");
        }
        String keyType = keyBuffer.readString();
        logger.info("Read key type: {}", (Object)keyType);
        byte[] pubKey = keyBuffer.readBytes();
        keyBuffer.readUInt32();
        byte[] privKey = new byte[32];
        keyBuffer.readRawBytes(privKey);
        keyBuffer.readRawBytes(new byte[32]);
        String comment = keyBuffer.readString();
        byte[] padding = new byte[keyBuffer.available()];
        keyBuffer.readRawBytes(padding);
        for (int i = 0; i < padding.length; ++i) {
            if (padding[i] == i + 1) continue;
            throw new IOException("Padding of key format contained wrong byte at position: " + i);
        }
        return new KeyPair(publicKey, (PrivateKey)new EdDSAPrivateKey(new EdDSAPrivateKeySpec(privKey, (EdDSAParameterSpec)EdDSANamedCurveTable.getByName((String)"Ed25519"))));
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new OpenSSHKeyV1KeyFile();
        }

        @Override
        public String getName() {
            return KeyFormat.OpenSSHv1.name();
        }
    }
}

