/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.compression;

import com.jcraft.jzlib.ZStream;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.compression.Compression;

public class ZlibCompression
implements Compression {
    private static final int BUF_SIZE = 4096;
    private final byte[] tempBuf = new byte[4096];
    private ZStream stream;

    @Override
    public void init(Compression.Mode mode) {
        this.stream = new ZStream();
        switch (mode) {
            case DEFLATE: {
                this.stream.deflateInit(-1);
                break;
            }
            case INFLATE: {
                this.stream.inflateInit();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public boolean isDelayed() {
        return false;
    }

    @Override
    public void compress(Buffer buffer) {
        this.stream.next_in = buffer.array();
        this.stream.next_in_index = buffer.rpos();
        this.stream.avail_in = buffer.available();
        buffer.wpos(buffer.rpos());
        do {
            this.stream.next_out = this.tempBuf;
            this.stream.next_out_index = 0;
            this.stream.avail_out = 4096;
            int status = this.stream.deflate(1);
            if (status != 0) {
                throw new SSHRuntimeException("compress: deflate returned " + status);
            }
            buffer.putRawBytes(this.tempBuf, 0, 4096 - this.stream.avail_out);
        } while (this.stream.avail_out == 0);
    }

    @Override
    public void uncompress(Buffer from, Buffer to) throws TransportException {
        int status;
        this.stream.next_in = from.array();
        this.stream.next_in_index = from.rpos();
        this.stream.avail_in = from.available();
        block4: while (true) {
            this.stream.next_out = this.tempBuf;
            this.stream.next_out_index = 0;
            this.stream.avail_out = 4096;
            status = this.stream.inflate(1);
            switch (status) {
                case 0: {
                    to.putRawBytes(this.tempBuf, 0, 4096 - this.stream.avail_out);
                    continue block4;
                }
                case -5: {
                    return;
                }
            }
            break;
        }
        throw new TransportException(DisconnectReason.COMPRESSION_ERROR, "uncompress: inflate returned " + status);
    }

    public static class Factory
    implements Factory.Named<Compression> {
        @Override
        public Compression create() {
            return new ZlibCompression();
        }

        @Override
        public String getName() {
            return "zlib";
        }
    }
}

