/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.PacketType;
import net.schmizz.sshj.sftp.PathComponents;
import net.schmizz.sshj.sftp.RemoteResource;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;

public class RemoteDirectory
extends RemoteResource {
    public RemoteDirectory(SFTPEngine requester, String path, byte[] handle) {
        super(requester, path, handle);
    }

    public List<RemoteResourceInfo> scan(RemoteResourceFilter filter) throws IOException {
        LinkedList<RemoteResourceInfo> rri = new LinkedList<RemoteResourceInfo>();
        block4: while (true) {
            Response res = this.requester.request(this.newRequest(PacketType.READDIR)).retrieve(this.requester.getTimeoutMs(), TimeUnit.MILLISECONDS);
            switch (res.getType()) {
                case NAME: {
                    int count = res.readUInt32AsInt();
                    int i = 0;
                    while (true) {
                        if (i >= count) continue block4;
                        String name = res.readString();
                        res.readString();
                        FileAttributes attrs = res.readFileAttributes();
                        PathComponents comps = this.requester.getPathHelper().getComponents(this.path, name);
                        RemoteResourceInfo inf = new RemoteResourceInfo(comps, attrs);
                        if (!(".".equals(name) || "..".equals(name) || filter != null && !filter.accept(inf))) {
                            rri.add(inf);
                        }
                        ++i;
                    }
                }
                case STATUS: {
                    res.ensureStatusIs(Response.StatusCode.EOF);
                    break block4;
                }
                default: {
                    throw new SFTPException("Unexpected packet: " + (Object)((Object)res.getType()));
                }
            }
            break;
        }
        return rri;
    }
}

