/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel.direct;

import com.hierynomus.sshj.backport.Sockets;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.TimeUnit;
import net.schmizz.concurrent.Event;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.channel.SocketStreamCopyMonitor;
import net.schmizz.sshj.connection.channel.direct.AbstractDirectChannel;
import org.slf4j.Logger;

public class LocalPortForwarder {
    private final LoggerFactory loggerFactory;
    private final Logger log;
    private final Connection conn;
    private final Parameters parameters;
    private final ServerSocket serverSocket;
    private Thread runningThread;

    public LocalPortForwarder(Connection conn, Parameters parameters, ServerSocket serverSocket, LoggerFactory loggerFactory) {
        this.conn = conn;
        this.parameters = parameters;
        this.serverSocket = serverSocket;
        this.loggerFactory = loggerFactory;
        this.log = loggerFactory.getLogger(this.getClass());
    }

    private void startChannel(Socket socket) throws IOException {
        DirectTCPIPChannel chan = new DirectTCPIPChannel(this.conn, socket, this.parameters);
        try {
            chan.open();
            chan.start();
        }
        catch (IOException e) {
            IOUtils.closeQuietly(chan, Sockets.asCloseable(socket));
            throw e;
        }
    }

    public void listen() throws IOException {
        this.listen(Thread.currentThread());
    }

    public void listen(Thread runningThread) throws IOException {
        this.runningThread = runningThread;
        this.log.info("Listening on {}", (Object)this.serverSocket.getLocalSocketAddress());
        while (!runningThread.isInterrupted()) {
            try {
                Socket socket = this.serverSocket.accept();
                this.log.debug("Got connection from {}", (Object)socket.getRemoteSocketAddress());
                this.startChannel(socket);
            }
            catch (SocketException e) {
                if (this.serverSocket.isClosed()) continue;
                throw e;
            }
        }
        if (this.serverSocket.isClosed()) {
            this.log.debug("LocalPortForwarder closed");
        } else {
            this.log.debug("LocalPortForwarder interrupted!");
        }
    }

    public void close() throws IOException {
        if (!this.serverSocket.isClosed()) {
            this.log.info("Closing listener on {}", (Object)this.serverSocket.getLocalSocketAddress());
            this.serverSocket.close();
            this.runningThread.interrupt();
        }
    }

    public static class DirectTCPIPChannel
    extends AbstractDirectChannel {
        protected final Socket socket;
        protected final Parameters parameters;

        public DirectTCPIPChannel(Connection conn, Socket socket, Parameters parameters) {
            super(conn, "direct-tcpip");
            this.socket = socket;
            this.parameters = parameters;
        }

        protected void start() throws IOException {
            this.socket.setSendBufferSize(this.getLocalMaxPacketSize());
            this.socket.setReceiveBufferSize(this.getRemoteMaxPacketSize());
            Event<IOException> soc2chan = new StreamCopier(this.socket.getInputStream(), this.getOutputStream(), this.loggerFactory).bufSize(this.getRemoteMaxPacketSize()).spawnDaemon("soc2chan");
            Event<IOException> chan2soc = new StreamCopier(this.getInputStream(), this.socket.getOutputStream(), this.loggerFactory).bufSize(this.getLocalMaxPacketSize()).spawnDaemon("chan2soc");
            SocketStreamCopyMonitor.monitor(5, TimeUnit.SECONDS, soc2chan, chan2soc, this, this.socket);
        }

        @Override
        protected SSHPacket buildOpenReq() {
            return (SSHPacket)((SSHPacket)((SSHPacket)((SSHPacket)super.buildOpenReq().putString(this.parameters.getRemoteHost())).putUInt32(this.parameters.getRemotePort())).putString(this.parameters.getLocalHost())).putUInt32(this.parameters.getLocalPort());
        }
    }

    public static class Parameters {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;

        public Parameters(String localHost, int localPort, String remoteHost, int remotePort) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
        }

        public String getRemoteHost() {
            return this.remoteHost;
        }

        public int getRemotePort() {
            return this.remotePort;
        }

        public String getLocalHost() {
            return this.localHost;
        }

        public int getLocalPort() {
            return this.localPort;
        }
    }
}

