/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.settings;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EHandled;
import com.helger.network.proxy.settings.IProxySettings;
import com.helger.network.proxy.settings.IProxySettingsProvider;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ProxySettingsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxySettingsManager.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsList<IProxySettingsProvider> LIST = new CommonsArrayList();

    private ProxySettingsManager() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IProxySettingsProvider> getAllProviders() {
        return (ICommonsList)RW_LOCK.readLockedGet(() -> LIST.getClone());
    }

    public static void registerProvider(@Nonnull IProxySettingsProvider iProxySettingsProvider) {
        ValueEnforcer.notNull((Object)iProxySettingsProvider, (String)"Provider");
        RW_LOCK.writeLocked(() -> LIST.add((Object)iProxySettingsProvider));
        LOGGER.info("Registered proxy settings provider " + String.valueOf(iProxySettingsProvider));
    }

    @Nonnull
    public static EChange unregisterProvider(@Nullable IProxySettingsProvider iProxySettingsProvider) {
        if (iProxySettingsProvider == null) {
            return EChange.UNCHANGED;
        }
        EChange eChange = (EChange)RW_LOCK.writeLockedGet(() -> LIST.removeObject((Object)iProxySettingsProvider));
        if (eChange.isChanged()) {
            LOGGER.info("Unregistered proxy settings provider " + String.valueOf(iProxySettingsProvider));
        }
        return eChange;
    }

    @Nonnull
    public static EChange removeAllProviders() {
        EChange eChange = (EChange)RW_LOCK.writeLockedGet(() -> LIST.removeAll());
        if (eChange.isChanged()) {
            LOGGER.info("Removed all proxy settings provider");
        }
        return eChange;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<IProxySettings> findAllProxySettings(@Nonnull URI uRI) {
        return ProxySettingsManager.findAllProxySettings(uRI.getScheme(), uRI.getHost(), uRI.getPort());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<IProxySettings> findAllProxySettings(@Nullable String string, @Nullable String string2, @CheckForSigned int n) {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        for (IProxySettingsProvider iProxySettingsProvider : ProxySettingsManager.getAllProviders()) {
            ICommonsList<IProxySettings> iCommonsList = iProxySettingsProvider.getAllProxySettings(string, string2, n);
            if (iCommonsList == null) continue;
            commonsLinkedHashSet.addAll(iCommonsList);
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    public static EHandled onConnectionFailed(@Nonnull URI uRI, @Nonnull SocketAddress socketAddress, @Nonnull IOException iOException) {
        String string = uRI.getScheme();
        String string2 = uRI.getHost();
        int n = uRI.getPort();
        int n2 = 0;
        for (IProxySettingsProvider iProxySettingsProvider : ProxySettingsManager.getAllProviders()) {
            ICommonsList<IProxySettings> iCommonsList = iProxySettingsProvider.getAllProxySettings(string, string2, n);
            if (iCommonsList == null) continue;
            for (IProxySettings iProxySettings : iCommonsList) {
                if (!iProxySettings.hasSocketAddress(socketAddress)) continue;
                iProxySettingsProvider.onConnectionFailed(iProxySettings, uRI, socketAddress, iOException);
                ++n2;
            }
        }
        return EHandled.valueOf((n2 > 0 ? 1 : 0) != 0);
    }
}

