/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.port;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.concurrent.ExecutorServiceHelper;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.datetime.PDTFactory;
import com.helger.network.port.ENetworkOnlineStatus;
import com.helger.network.port.NetworkPortHelper;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class NetworkOnlineStatusDeterminator {
    public static final Duration DEFAULT_CACHE_DURATION = Duration.ofMinutes(1L);
    public static final int DEFAULT_CONNECTION_TIMEOUT_MILLISECONDS = 2000;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static Duration s_aCacheDuration = DEFAULT_CACHE_DURATION;
    @GuardedBy(value="RW_LOCK")
    private static int s_nConnectionTimeout = 2000;
    @GuardedBy(value="RW_LOCK")
    private static LocalDateTime s_aLastCheckDT = null;
    @GuardedBy(value="RW_LOCK")
    private static ENetworkOnlineStatus s_eStatus = ENetworkOnlineStatus.UNDEFINED;
    private static final NetworkOnlineStatusDeterminator INSTANCE = new NetworkOnlineStatusDeterminator();

    private NetworkOnlineStatusDeterminator() {
    }

    @Nonnull
    public static Duration getCacheDuration() {
        return (Duration)RW_LOCK.readLockedGet(() -> s_aCacheDuration);
    }

    public static void setCacheDuration(@Nonnull Duration duration) {
        ValueEnforcer.notNull((Object)duration, (String)"CacheDuration");
        RW_LOCK.writeLockedGet(() -> {
            s_aCacheDuration = duration;
            return s_aCacheDuration;
        });
    }

    @Nonnegative
    public static int getConnectionTimeoutMilliseconds() {
        return RW_LOCK.readLockedInt(() -> s_nConnectionTimeout);
    }

    public static void setConnectionTimeoutMilliseconds(int n) {
        ValueEnforcer.isGT0((int)n, (String)"ConnectionTimeout");
        RW_LOCK.writeLockedInt(() -> {
            s_nConnectionTimeout = n;
            return s_nConnectionTimeout;
        });
    }

    @Nullable
    public static LocalDateTime getLastCheckDT() {
        return (LocalDateTime)RW_LOCK.readLockedGet(() -> s_aLastCheckDT);
    }

    @Nonnull
    public static ENetworkOnlineStatus getCachedNetworkStatus() {
        return (ENetworkOnlineStatus)((Object)RW_LOCK.readLockedGet(() -> s_eStatus));
    }

    public static void resetCachedStatus() {
        RW_LOCK.writeLocked(() -> {
            s_aLastCheckDT = null;
            s_eStatus = ENetworkOnlineStatus.UNDEFINED;
        });
    }

    @Nonnull
    public static ENetworkOnlineStatus getNetworkStatus() {
        RW_LOCK.readLock().lock();
        try {
            if (s_eStatus.isDefined()) {
                LocalDateTime localDateTime = PDTFactory.getCurrentLocalDateTime();
                if (s_aLastCheckDT != null && s_aLastCheckDT.plus(s_aCacheDuration).isAfter(localDateTime)) {
                    ENetworkOnlineStatus eNetworkOnlineStatus = s_eStatus;
                    return eNetworkOnlineStatus;
                }
            }
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
        return NetworkOnlineStatusDeterminator.getNetworkStatusNoCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ENetworkOnlineStatus getNetworkStatusNoCache() {
        LocalDateTime localDateTime = PDTFactory.getCurrentLocalDateTime();
        RW_LOCK.writeLock().lock();
        try {
            CommonsArrayList commonsArrayList = new CommonsArrayList((Object[])new String[]{"www.google.com", "www.facebook.com", "www.microsoft.com"});
            ExecutorService executorService = Executors.newFixedThreadPool(commonsArrayList.size());
            AtomicInteger atomicInteger = new AtomicInteger(0);
            for (String string : commonsArrayList) {
                executorService.submit(() -> {
                    if (NetworkPortHelper.checkPortOpen(string, 443, s_nConnectionTimeout, true).isPortOpen()) {
                        atomicInteger.incrementAndGet();
                    }
                });
            }
            ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished((ExecutorService)executorService);
            s_eStatus = atomicInteger.intValue() > 0 ? ENetworkOnlineStatus.ONLINE : ENetworkOnlineStatus.OFFLINE;
            s_aLastCheckDT = localDateTime;
            Object object = s_eStatus;
            return object;
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }
}

