/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.port;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ServerSocketFactory;

public enum ENetworkProtocol implements IHasID<String>
{
    TCP("tcp"){

        @Override
        public boolean isPortAvailable(int n) {
            if (n >= 0) {
                boolean bl;
                block9: {
                    ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(n, 1, InetAddress.getByName("localhost"));
                    try {
                        serverSocket.setReuseAddress(true);
                        bl = true;
                        if (serverSocket == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (serverSocket != null) {
                                try {
                                    serverSocket.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    serverSocket.close();
                }
                return bl;
            }
            return false;
        }
    }
    ,
    UDP("udp"){

        @Override
        public boolean isPortAvailable(int n) {
            if (n >= 0) {
                DatagramSocket datagramSocket = new DatagramSocket(n, InetAddress.getByName("localhost"));
                try {
                    datagramSocket.setReuseAddress(true);
                    boolean bl = true;
                    datagramSocket.close();
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            datagramSocket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return false;
        }
    };

    private final String m_sID;

    private ENetworkProtocol(String string2) {
        this.m_sID = string2;
    }

    public abstract boolean isPortAvailable(int var1);

    public boolean isPortUsed(int n) {
        return !this.isPortAvailable(n);
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nullable
    public static ENetworkProtocol getFromIDOrNull(@Nullable String string) {
        return (ENetworkProtocol)EnumHelper.getFromIDOrNull(ENetworkProtocol.class, (Object)string);
    }
}

