/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.csp;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.base64.Base64;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.commons.url.ISimpleURL;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractCSPSourceList<IMPLTYPE extends AbstractCSPSourceList<IMPLTYPE>>
implements IGenericImplTrait<IMPLTYPE> {
    public static final String KEYWORD_NONE = "'none'";
    public static final String KEYWORD_REPORT_SAMPLE = "'report-sample'";
    public static final String KEYWORD_SELF = "'self'";
    public static final String KEYWORD_STRICT_DYNAMIC = "'strict-dynamic'";
    public static final String KEYWORD_UNSAFE_INLINE = "'unsafe-inline'";
    public static final String KEYWORD_UNSAFE_EVAL = "'unsafe-eval'";
    public static final String NONCE_PREFIX = "'nonce-";
    public static final String NONCE_SUFFIX = "'";
    public static final String HASH_PREFIX = "'";
    public static final String HASH_SUFFIX = "'";
    private final ICommonsOrderedSet<String> m_aList = new CommonsLinkedHashSet();

    @Nonnegative
    public int getExpressionCount() {
        return this.m_aList.size();
    }

    @Nonnull
    public IMPLTYPE addScheme(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Scheme");
        ValueEnforcer.isTrue((string.length() > 1 && string.endsWith(":") ? 1 : 0) != 0, () -> "Passed scheme '" + string + "' is invalid!");
        this.m_aList.add((Object)string);
        return (IMPLTYPE)((AbstractCSPSourceList)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE addHost(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"Host");
        return this.addHost(iSimpleURL.getAsStringWithEncodedParameters());
    }

    @Nonnull
    public IMPLTYPE addHost(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Host");
        this.m_aList.add((Object)string);
        return (IMPLTYPE)((AbstractCSPSourceList)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE addMimeType(@Nonnull IMimeType iMimeType) {
        ValueEnforcer.notNull((Object)iMimeType, (String)"aMimeType");
        this.m_aList.add((Object)iMimeType.getAsString());
        return (IMPLTYPE)((AbstractCSPSourceList)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE addKeywordNone() {
        this.m_aList.add((Object)KEYWORD_NONE);
        return (IMPLTYPE)((AbstractCSPSourceList)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE addKeywordReportSample() {
        this.m_aList.add((Object)KEYWORD_REPORT_SAMPLE);
        return (IMPLTYPE)((AbstractCSPSourceList)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE addKeywordSelf() {
        this.m_aList.add((Object)KEYWORD_SELF);
        return (IMPLTYPE)((AbstractCSPSourceList)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE addKeywordStrictDynamic() {
        this.m_aList.add((Object)KEYWORD_STRICT_DYNAMIC);
        return (IMPLTYPE)((AbstractCSPSourceList)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE addKeywordUnsafeEval() {
        this.m_aList.add((Object)KEYWORD_UNSAFE_EVAL);
        return (IMPLTYPE)((AbstractCSPSourceList)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE addKeywordUnsafeInline() {
        this.m_aList.add((Object)KEYWORD_UNSAFE_INLINE);
        return (IMPLTYPE)((AbstractCSPSourceList)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE addNonce(@Nonnull @Nonempty byte[] byArray) {
        ValueEnforcer.notEmpty((byte[])byArray, (String)"NonceValue");
        return this.addNonce(Base64.safeEncodeBytes((byte[])byArray));
    }

    @Nonnull
    public IMPLTYPE addNonce(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"NonceBase64Value");
        this.m_aList.add((Object)(NONCE_PREFIX + string + "'"));
        return (IMPLTYPE)((AbstractCSPSourceList)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE addHash(@Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonnull @Nonempty byte[] byArray) {
        ValueEnforcer.notEmpty((byte[])byArray, (String)"HashValue");
        return this.addHash(eMessageDigestAlgorithm, Base64.safeEncodeBytes((byte[])byArray));
    }

    @Nonnull
    public IMPLTYPE addHash(@Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonnull String string) {
        String string2;
        ValueEnforcer.notNull((Object)eMessageDigestAlgorithm, (String)"MDAlgo");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"HashBase64Value");
        switch (eMessageDigestAlgorithm) {
            case SHA_256: {
                string2 = "sha256";
                break;
            }
            case SHA_384: {
                string2 = "sha384";
                break;
            }
            case SHA_512: {
                string2 = "sha512";
                break;
            }
            default: {
                throw new IllegalArgumentException("Only SHA256, SHA384 and SHA512 are supported algorithms");
            }
        }
        this.m_aList.add((Object)("'" + string2 + "-" + string + "'"));
        return (IMPLTYPE)((AbstractCSPSourceList)this.thisAsT());
    }

    @Nonnull
    public String getAsString() {
        return StringHelper.getImploded((char)' ', this.m_aList);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractCSPSourceList abstractCSPSourceList = (AbstractCSPSourceList)object;
        return this.m_aList.equals(abstractCSPSourceList.m_aList);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aList).getHashCode();
    }

    @Nonnull
    public String toString() {
        return new ToStringGenerator((Object)this).append("List", this.m_aList).getToString();
    }
}

