/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.basicauth;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.base64.Base64;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.http.basicauth.BasicAuthClientCredentials;
import com.helger.http.digestauth.HttpDigestAuth;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class HttpBasicAuth {
    public static final String HEADER_VALUE_PREFIX_BASIC = "Basic";
    public static final char USERNAME_PASSWORD_SEPARATOR = ':';
    public static final Charset CHARSET = StandardCharsets.ISO_8859_1;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDigestAuth.class);
    private static final HttpBasicAuth INSTANCE = new HttpBasicAuth();

    private HttpBasicAuth() {
    }

    @Nullable
    public static BasicAuthClientCredentials getBasicAuthClientCredentials(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.hasNoText((String)string2)) {
            return null;
        }
        String[] stringArray = RegExHelper.getSplitToArray((CharSequence)string2, (String)"\\s+", (int)2);
        if (stringArray.length != 2) {
            LOGGER.error("String is not Basic Auth: " + string2);
            return null;
        }
        if (!stringArray[0].equals(HEADER_VALUE_PREFIX_BASIC)) {
            LOGGER.error("String does not start with 'Basic': " + string2);
            return null;
        }
        String string3 = stringArray[1];
        String string4 = Base64.safeDecodeAsString((String)string3, (Charset)CHARSET);
        if (string4 == null) {
            LOGGER.error("Illegal Base64 encoded value '" + string3 + "'");
            return null;
        }
        int n = string4.indexOf(58);
        if (n >= 0) {
            return new BasicAuthClientCredentials(string4.substring(0, n), string4.substring(n + 1));
        }
        return new BasicAuthClientCredentials(string4);
    }

    @Nonnull
    @Nonempty
    public static String getHttpHeaderValue(@Nonnull @Nonempty String string, @Nullable String string2) {
        String string3 = StringHelper.getConcatenatedOnDemand((String)string, (char)':', (String)string2);
        return "Basic " + Base64.safeEncode((String)string3, (Charset)CHARSET);
    }
}

