/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.http.RFC7230Helper;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HttpForwardedHeaderHop {
    public static final String PARAM_FOR = "for";
    public static final String PARAM_HOST = "host";
    public static final String PARAM_BY = "by";
    public static final String PARAM_PROTO = "proto";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpForwardedHeaderHop.class);
    private final ICommonsOrderedMap<String, String> m_aPairs = new CommonsLinkedHashMap();

    @Nonnull
    private static String _getUnifiedToken(@Nonnull String string) {
        return string.toLowerCase(Locale.ROOT);
    }

    @Nonnull
    public HttpForwardedHeaderHop addPair(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Token");
        ValueEnforcer.isTrue(() -> RFC7230Helper.isValidToken(string), (String)"Token is not valid according to RFC 7230");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        String string3 = HttpForwardedHeaderHop._getUnifiedToken(string);
        if (this.m_aPairs.containsKey((Object)string3)) {
            LOGGER.warn("Overwriting value of token '" + string3 + "'");
        }
        this.m_aPairs.put((Object)string3, (Object)string2);
        return this;
    }

    @Nullable
    public String getFirstValue(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Token");
        return (String)this.m_aPairs.get((Object)HttpForwardedHeaderHop._getUnifiedToken(string));
    }

    public boolean containsToken(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Token");
        return this.m_aPairs.containsKey((Object)HttpForwardedHeaderHop._getUnifiedToken(string));
    }

    public boolean containsFor() {
        return this.containsToken(PARAM_FOR);
    }

    public boolean containsHost() {
        return this.containsToken(PARAM_HOST);
    }

    public boolean containsBy() {
        return this.containsToken(PARAM_BY);
    }

    public boolean containsProto() {
        return this.containsToken(PARAM_PROTO);
    }

    @Nullable
    public EChange removePair(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Token");
        return this.m_aPairs.removeObject((Object)HttpForwardedHeaderHop._getUnifiedToken(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllTokens() {
        return this.m_aPairs.copyOfKeySet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllPairs() {
        return this.m_aPairs.getClone();
    }

    @Nonnull
    public HttpForwardedHeaderHop removeAll() {
        this.m_aPairs.clear();
        return this;
    }

    public boolean isEmpty() {
        return this.m_aPairs.isEmpty();
    }

    public boolean isNotEmpty() {
        return this.m_aPairs.isNotEmpty();
    }

    public int size() {
        return this.m_aPairs.size();
    }

    @Nonnull
    public HttpForwardedHeaderHop setFor(@Nonnull String string) {
        return this.addPair(PARAM_FOR, string);
    }

    @Nullable
    public String getFor() {
        return this.getFirstValue(PARAM_FOR);
    }

    @Nonnull
    public HttpForwardedHeaderHop setHost(@Nonnull String string) {
        return this.addPair(PARAM_HOST, string);
    }

    @Nullable
    public String getHost() {
        return this.getFirstValue(PARAM_HOST);
    }

    @Nonnull
    public HttpForwardedHeaderHop setBy(@Nonnull String string) {
        return this.addPair(PARAM_BY, string);
    }

    @Nullable
    public String getBy() {
        return this.getFirstValue(PARAM_BY);
    }

    @Nonnull
    public HttpForwardedHeaderHop setProto(@Nonnull String string) {
        return this.addPair(PARAM_PROTO, string);
    }

    @Nullable
    public String getProto() {
        return this.getFirstValue(PARAM_PROTO);
    }

    private static boolean _needsQuoting(@Nonnull String string) {
        return !RFC7230Helper.isValidToken(string);
    }

    @Nonnull
    public String getAsString() {
        if (this.m_aPairs.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry entry : this.m_aPairs.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(';');
            }
            stringBuilder.append(string).append('=');
            if (HttpForwardedHeaderHop._needsQuoting(string2)) {
                stringBuilder.append('\"');
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (c == '\"' || c == '\\') {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c);
                }
                stringBuilder.append('\"');
                continue;
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        HttpForwardedHeaderHop httpForwardedHeaderHop = (HttpForwardedHeaderHop)object;
        return this.m_aPairs.equals(httpForwardedHeaderHop.m_aPairs);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aPairs).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Pairs", this.m_aPairs).getToString();
    }
}

