/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.http.QValue;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class AbstractQValueList<KEYTYPE> {
    private final ICommonsOrderedMap<KEYTYPE, QValue> m_aMap = new CommonsLinkedHashMap();

    @Nonnull
    @ReturnsMutableCopy
    protected final ICommonsOrderedMap<KEYTYPE, QValue> qvalueMap() {
        return this.m_aMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<KEYTYPE, QValue> getAllQValues() {
        return this.m_aMap.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<KEYTYPE, QValue> getAllQValuesLowerThan(double d) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            QValue qValue = (QValue)entry.getValue();
            if (!(qValue.getQuality() < d)) continue;
            commonsLinkedHashMap.put(entry.getKey(), (Object)qValue);
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<KEYTYPE, QValue> getAllQValuesLowerOrEqual(double d) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            QValue qValue = (QValue)entry.getValue();
            if (!(qValue.getQuality() <= d)) continue;
            commonsLinkedHashMap.put(entry.getKey(), (Object)qValue);
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<KEYTYPE, QValue> getAllQValuesGreaterThan(double d) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            QValue qValue = (QValue)entry.getValue();
            if (!(qValue.getQuality() > d)) continue;
            commonsLinkedHashMap.put(entry.getKey(), (Object)qValue);
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<KEYTYPE, QValue> getAllQValuesGreaterOrEqual(double d) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            QValue qValue = (QValue)entry.getValue();
            if (!(qValue.getQuality() >= d)) continue;
            commonsLinkedHashMap.put(entry.getKey(), (Object)qValue);
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    public abstract String getAsHttpHeaderValue();

    @Nonnull
    protected String getAsHttpHeaderValue(@Nonnull Function<KEYTYPE, String> function) {
        return AbstractQValueList.getAsHttpHeaderValue(this.m_aMap, function);
    }

    @Nonnull
    public static <T> String getAsHttpHeaderValue(@Nonnull ICommonsOrderedMap<T, QValue> iCommonsOrderedMap, @Nonnull Function<T, String> function) {
        ValueEnforcer.notNull(iCommonsOrderedMap, (String)"Map");
        ValueEnforcer.notNull(function, (String)"KeyTransformer");
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : iCommonsOrderedMap.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(function.apply(entry.getKey())).append("; q=").append(((QValue)entry.getValue()).getQuality());
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractQValueList abstractQValueList = (AbstractQValueList)object;
        return this.m_aMap.equals(abstractQValueList.m_aMap);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMap).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).getToString();
    }
}

