/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.basicauth;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.http.basicauth.HttpBasicAuth;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class BasicAuthClientCredentials {
    private final String m_sUserName;
    private final String m_sPassword;

    public BasicAuthClientCredentials(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public BasicAuthClientCredentials(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_sUserName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"UserName");
        this.m_sPassword = StringHelper.hasNoText((String)string2) ? null : string2;
    }

    @Nonnull
    @Nonempty
    public String getUserName() {
        return this.m_sUserName;
    }

    @Nullable
    public String getPassword() {
        return this.m_sPassword;
    }

    public boolean hasPassword() {
        return this.m_sPassword != null;
    }

    @Nonnull
    @Nonempty
    public String getRequestValue() {
        return HttpBasicAuth.getHttpHeaderValue(this.m_sUserName, this.m_sPassword);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BasicAuthClientCredentials basicAuthClientCredentials = (BasicAuthClientCredentials)object;
        return this.m_sUserName.equals(basicAuthClientCredentials.m_sUserName) && EqualsHelper.equals((Object)this.m_sPassword, (Object)basicAuthClientCredentials.m_sPassword);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sUserName).append((Object)this.m_sPassword).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("UserName", (Object)this.m_sUserName).appendPassword("Password").getToString();
    }
}

