/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class QValue
implements Comparable<QValue> {
    public static final double MIN_QUALITY = 0.0;
    public static final double MAX_QUALITY = 1.0;
    public static final double HALF_QUALITY = 0.5;
    private static final Logger LOGGER = LoggerFactory.getLogger(QValue.class);
    public static final QValue MIN_QVALUE = new QValue(0.0);
    public static final QValue MAX_QVALUE = new QValue(1.0);
    private final double m_dQuality;

    public QValue(@Nonnegative double d) {
        if (d < 0.0) {
            LOGGER.warn("QValue is too small: " + d);
        } else if (d > 1.0) {
            LOGGER.warn("QValue is too large: " + d);
        }
        this.m_dQuality = QValue.getValueInRange(d);
    }

    public static double getValueInRange(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        if (d > 1.0) {
            return 1.0;
        }
        return d;
    }

    @Nonnegative
    public double getQuality() {
        return this.m_dQuality;
    }

    public boolean isMinimumQuality() {
        return EqualsHelper.equals((double)this.m_dQuality, (double)0.0);
    }

    public boolean isAboveMinimumQuality() {
        return this.m_dQuality > 0.0;
    }

    public boolean isLowValue() {
        return this.m_dQuality <= 0.5;
    }

    public boolean isHighValue() {
        return this.m_dQuality > 0.5;
    }

    public boolean isBelowMaximumQuality() {
        return this.m_dQuality < 1.0;
    }

    public boolean isMaximumQuality() {
        return EqualsHelper.equals((double)this.m_dQuality, (double)1.0);
    }

    public boolean isBetweenMinimumAndMaximum() {
        return this.isAboveMinimumQuality() && this.isBelowMaximumQuality();
    }

    @Override
    public int compareTo(@Nonnull QValue qValue) {
        return Double.compare(this.m_dQuality, qValue.m_dQuality);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        QValue qValue = (QValue)object;
        return EqualsHelper.equals((double)this.m_dQuality, (double)qValue.m_dQuality);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_dQuality).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Quality", this.m_dQuality).getToString();
    }
}

