/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron;

import com.helger.commons.ValueEnforcer;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SchematronDebug {
    public static final boolean DEFAULT_DEBUG = false;
    private static final AtomicBoolean SAVE_INTERMEDIATE_XSLT_FILES = new AtomicBoolean(false);
    private static File s_aIntermediateMinifiedSCHFolder = new File("generated/test-minified");
    private static File s_aIntermediateFinalXSLTFolder = new File("generated/test-final");
    private static final AtomicBoolean SHOW_CREATED_XSLT = new AtomicBoolean(false);
    private static final AtomicBoolean SHOW_CREATED_SVRL = new AtomicBoolean(false);
    private static final AtomicBoolean SHOW_PREPROCESSED_SCH = new AtomicBoolean(false);
    private static final AtomicBoolean SHOW_RESOLVED_SOURCE_SCH = new AtomicBoolean(false);

    private SchematronDebug() {
    }

    public static void setDebugMode(boolean bl) {
        SchematronDebug.setSaveIntermediateXSLTFiles(bl);
        SchematronDebug.setShowCreatedXSLT(bl);
        SchematronDebug.setShowCreatedSVRL(bl);
        SchematronDebug.setShowResolvedSourceSchematron(bl);
        SchematronDebug.setShowPreprocessedSchematron(bl);
    }

    public static void inDebugMode(@Nonnull Runnable runnable) {
        SchematronDebug.setDebugMode(true);
        try {
            runnable.run();
        }
        finally {
            SchematronDebug.setDebugMode(false);
        }
    }

    public static boolean isSaveIntermediateXSLTFiles() {
        return SAVE_INTERMEDIATE_XSLT_FILES.get();
    }

    public static void setSaveIntermediateXSLTFiles(boolean bl) {
        SAVE_INTERMEDIATE_XSLT_FILES.set(bl);
    }

    @Nonnull
    public static File getIntermediateMinifiedSCHFolder() {
        return s_aIntermediateMinifiedSCHFolder;
    }

    public static void setIntermediateMinifiedSCHFolder(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"IntermediateMinifiedSCHFolder");
        s_aIntermediateMinifiedSCHFolder = file;
    }

    @Nonnull
    public static File getIntermediateFinalXSLTFolder() {
        return s_aIntermediateFinalXSLTFolder;
    }

    public static void setIntermediateFinalXSLTFolder(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"IntermediateFinalXSLTFolder");
        s_aIntermediateFinalXSLTFolder = file;
    }

    public static boolean isShowCreatedXSLT() {
        return SHOW_CREATED_XSLT.get();
    }

    public static void setShowCreatedXSLT(boolean bl) {
        SHOW_CREATED_XSLT.set(bl);
    }

    public static boolean isShowCreatedSVRL() {
        return SHOW_CREATED_SVRL.get();
    }

    public static void setShowCreatedSVRL(boolean bl) {
        SHOW_CREATED_SVRL.set(bl);
    }

    public static boolean isShowResolvedSourceSchematron() {
        return SHOW_RESOLVED_SOURCE_SCH.get();
    }

    public static void setShowResolvedSourceSchematron(boolean bl) {
        SHOW_RESOLVED_SOURCE_SCH.set(bl);
    }

    public static boolean isShowPreprocessedSchematron() {
        return SHOW_PREPROCESSED_SCH.get();
    }

    public static void setShowPreprocessedSchematron(boolean bl) {
        SHOW_PREPROCESSED_SCH.set(bl);
    }
}

