/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsEnumMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.xml.XMLFactory;
import com.helger.xml.dom.EXMLDOMFeature;
import com.helger.xml.dom.EXMLDOMFeatureVersion;
import com.helger.xml.dom.EXMLDOMNodeType;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;

public final class XMLDebug {
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLDebug.class);
    private static final ICommonsMap<EXMLDOMFeatureVersion, ICommonsList<String>> s_aSupportedFeatures = new CommonsEnumMap(EXMLDOMFeatureVersion.class);
    private static final XMLDebug s_aInstance;

    private static void _initFeature(@Nonnull EXMLDOMFeature eXMLDOMFeature) {
        DOMImplementation dOMImplementation = XMLFactory.getDOMImplementation();
        for (EXMLDOMFeatureVersion eXMLDOMFeatureVersion : EXMLDOMFeatureVersion.values()) {
            if (dOMImplementation.hasFeature(eXMLDOMFeature.getID(), eXMLDOMFeatureVersion.getID())) {
                ((ICommonsList)s_aSupportedFeatures.get((Object)eXMLDOMFeatureVersion)).add((Object)eXMLDOMFeature.getID());
                continue;
            }
            if (!dOMImplementation.hasFeature(eXMLDOMFeature.getPlusFeature(), eXMLDOMFeatureVersion.getID())) continue;
            ((ICommonsList)s_aSupportedFeatures.get((Object)eXMLDOMFeatureVersion)).add((Object)eXMLDOMFeature.getPlusFeature());
        }
    }

    private XMLDebug() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<EXMLDOMFeatureVersion, ICommonsList<String>> getAllSupportedFeatures() {
        return (ICommonsMap)s_aSupportedFeatures.getClone();
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsList<String> getAllSupportedFeatures(@Nonnull EXMLDOMFeatureVersion eXMLDOMFeatureVersion) {
        ICommonsList iCommonsList = (ICommonsList)s_aSupportedFeatures.get((Object)eXMLDOMFeatureVersion);
        return iCommonsList == null ? null : (ICommonsList)iCommonsList.getClone();
    }

    public static void debugLogDOMFeatures() {
        for (Map.Entry entry : s_aSupportedFeatures.entrySet()) {
            for (String string : (ICommonsList)entry.getValue()) {
                s_aLogger.info("DOM " + ((EXMLDOMFeatureVersion)((Object)entry.getKey())).getID() + " feature '" + string + "' is present");
            }
        }
    }

    @Nonnull
    public static String getNodeTypeAsString(int n) {
        EXMLDOMNodeType eXMLDOMNodeType = EXMLDOMNodeType.getFromIDOrNull(n);
        if (eXMLDOMNodeType != null) {
            return eXMLDOMNodeType.name();
        }
        s_aLogger.warn("Unknown Node type " + n);
        return Integer.toString(n);
    }

    static {
        for (EXMLDOMFeatureVersion eXMLDOMFeatureVersion : EXMLDOMFeatureVersion.values()) {
            s_aSupportedFeatures.put((Object)eXMLDOMFeatureVersion, (Object)new CommonsArrayList());
        }
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_CORE);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_XML);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_UI_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_MOUSE_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_TEXT_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_KEYBOARD_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_MUTATION_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_MUTATION_NAME_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_HTML_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_LS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_LS_ASYNC);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_VALIDATION);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_XPATH);
        s_aInstance = new XMLDebug();
    }
}

