/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.xml.schema.XMLSchemaCache;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.validation.Schema;

@NotThreadSafe
public class JAXBDocumentType
implements IJAXBDocumentType {
    private final Class<?> m_aClass;
    private final ICommonsList<String> m_aXSDPaths;
    private final String m_sNamespaceURI;
    private final String m_sLocalName;
    private Schema m_aCachedSchema;

    public JAXBDocumentType(@Nonnull Class<?> clazz, @Nullable List<String> list, @Nullable Function<? super String, ? extends String> function) {
        String string;
        String string2;
        ValueEnforcer.notNull(clazz, (String)"Class");
        ValueEnforcer.noNullValue(list, (String)"XSDPaths");
        XmlType xmlType = clazz.getAnnotation(XmlType.class);
        if (xmlType == null) {
            throw new IllegalArgumentException("The passed class does not have an @XmlType annotation!");
        }
        Package package_ = clazz.getPackage();
        XmlSchema xmlSchema = package_.getAnnotation(XmlSchema.class);
        if (xmlSchema != null && xmlSchema.namespace() == null) {
            throw new IllegalArgumentException("The package '" + package_.getName() + "' has no namespace URI in the @XmlSchema annotation!");
        }
        XmlRootElement xmlRootElement = clazz.getAnnotation(XmlRootElement.class);
        if (xmlRootElement != null) {
            string2 = xmlRootElement.namespace();
            if ("##default".equals(string2) && xmlSchema != null) {
                string2 = xmlSchema.namespace();
            }
            if ("##default".equals(string = xmlRootElement.name())) {
                string = xmlType.name();
            }
        } else {
            string2 = xmlSchema != null ? xmlSchema.namespace() : null;
            string = xmlType.name();
        }
        if (function != null) {
            string = function.apply(string);
        }
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("Failed to determine the local name of the element to be created!");
        }
        this.m_aClass = clazz;
        this.m_aXSDPaths = new CommonsArrayList(list);
        this.m_sNamespaceURI = StringHelper.getNotNull((String)string2);
        this.m_sLocalName = string;
    }

    @Override
    @Nonnull
    public Class<?> getImplementationClass() {
        return this.m_aClass;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllXSDPaths() {
        return (ICommonsList)this.m_aXSDPaths.getClone();
    }

    @Override
    @Nonnull
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getLocalName() {
        return this.m_sLocalName;
    }

    @Nonnull
    protected Schema createSchema(@Nullable ClassLoader classLoader) {
        ICommonsList<? extends IReadableResource> iCommonsList = this.getAllXSDResources(classLoader);
        Schema schema = XMLSchemaCache.getInstanceOfClassLoader((ClassLoader)classLoader).getSchema(iCommonsList);
        if (schema == null) {
            throw new IllegalStateException("Failed to create Schema from " + iCommonsList + (classLoader == null ? " with default class loader" : " using class loader " + classLoader));
        }
        return schema;
    }

    @Override
    @Nullable
    public Schema getSchema(@Nullable ClassLoader classLoader) {
        if (this.m_aXSDPaths.isEmpty()) {
            return null;
        }
        if (classLoader != null) {
            return this.createSchema(classLoader);
        }
        if (this.m_aCachedSchema == null) {
            this.m_aCachedSchema = this.createSchema(null);
        }
        return this.m_aCachedSchema;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JAXBDocumentType jAXBDocumentType = (JAXBDocumentType)object;
        return this.m_aClass.equals(jAXBDocumentType.m_aClass) && this.m_aXSDPaths.equals(jAXBDocumentType.m_aXSDPaths);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aClass).append(this.m_aXSDPaths).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Class", this.m_aClass).append("XSDPaths", this.m_aXSDPaths).append("NamespaceURI", (Object)this.m_sNamespaceURI).append("LocalName", (Object)this.m_sLocalName).getToString();
    }
}

