/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.xpath.XPathFunctionKey;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;

@NotThreadSafe
public class MapBasedXPathFunctionResolver
implements XPathFunctionResolver,
ICloneable<MapBasedXPathFunctionResolver> {
    private final Map<XPathFunctionKey, XPathFunction> m_aMap;

    public MapBasedXPathFunctionResolver() {
        this.m_aMap = new HashMap<XPathFunctionKey, XPathFunction>();
    }

    public MapBasedXPathFunctionResolver(@Nonnull MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver) {
        ValueEnforcer.notNull(mapBasedXPathFunctionResolver, "Other");
        this.m_aMap = CollectionHelper.newMap(mapBasedXPathFunctionResolver.m_aMap);
    }

    @Nonnull
    public EChange addUniqueFunction(@Nonnull String string, @Nonnull String string2, @Nonnegative int n, @Nonnull XPathFunction xPathFunction) {
        return this.addUniqueFunction(new QName(string, string2), n, xPathFunction);
    }

    @Nonnull
    public EChange addUniqueFunction(@Nonnull QName qName, @Nonnegative int n, @Nonnull XPathFunction xPathFunction) {
        ValueEnforcer.notNull(xPathFunction, "Function");
        XPathFunctionKey xPathFunctionKey = new XPathFunctionKey(qName, n);
        if (this.m_aMap.containsKey(xPathFunctionKey)) {
            return EChange.UNCHANGED;
        }
        this.m_aMap.put(xPathFunctionKey, xPathFunction);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange addAllFrom(@Nonnull MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver, boolean bl) {
        ValueEnforcer.notNull(mapBasedXPathFunctionResolver, "Other");
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry<XPathFunctionKey, XPathFunction> entry : mapBasedXPathFunctionResolver.m_aMap.entrySet()) {
            if (!bl && this.m_aMap.containsKey(entry.getKey())) continue;
            this.m_aMap.put(entry.getKey(), entry.getValue());
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    @Nonnull
    public EChange removeFunction(@Nonnull QName qName, @Nonnegative int n) {
        XPathFunctionKey xPathFunctionKey = new XPathFunctionKey(qName, n);
        return this.removeFunction(xPathFunctionKey);
    }

    @Nonnull
    public EChange removeFunction(@Nullable XPathFunctionKey xPathFunctionKey) {
        return EChange.valueOf(this.m_aMap.remove(xPathFunctionKey) != null);
    }

    @Nonnull
    public EChange removeFunctionsWithName(@Nullable QName qName) {
        EChange eChange = EChange.UNCHANGED;
        if (qName != null) {
            for (XPathFunctionKey xPathFunctionKey : CollectionHelper.newList(this.m_aMap.keySet())) {
                if (!xPathFunctionKey.getFunctionName().equals(qName)) continue;
                eChange = eChange.or(this.removeFunction(xPathFunctionKey));
            }
        }
        return eChange;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Map<XPathFunctionKey, XPathFunction> getAllFunctions() {
        return CollectionHelper.newMap(this.m_aMap);
    }

    @Nonnegative
    public int getFunctionCount() {
        return this.m_aMap.size();
    }

    @Nonnull
    public EChange clear() {
        if (this.m_aMap.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMap.clear();
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public XPathFunction resolveFunction(@Nonnull QName qName, @Nonnegative int n) {
        return this.resolveFunction(new XPathFunctionKey(qName, n));
    }

    @Nullable
    public XPathFunction resolveFunction(@Nullable XPathFunctionKey xPathFunctionKey) {
        return this.m_aMap.get(xPathFunctionKey);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public MapBasedXPathFunctionResolver getClone() {
        return new MapBasedXPathFunctionResolver(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver = (MapBasedXPathFunctionResolver)object;
        return EqualsHelper.equals(this.m_aMap, mapBasedXPathFunctionResolver.m_aMap);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aMap)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("map", this.m_aMap).toString();
    }
}

