/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.schema;

import com.helger.commons.xml.ls.SimpleLSResourceResolver;
import com.helger.commons.xml.sax.LoggingSAXErrorHandler;
import com.helger.commons.xml.schema.SchemaCache;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;

@ThreadSafe
public class XMLSchemaCache
extends SchemaCache {
    private static boolean s_bDefaultInstantiated = false;
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final Map<String, XMLSchemaCache> s_aPerClassLoaderCache = new HashMap<String, XMLSchemaCache>();

    @Nonnull
    public static SchemaFactory createXSDSchemaFactory() {
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    }

    public XMLSchemaCache() {
        this(new LoggingSAXErrorHandler(), new SimpleLSResourceResolver());
    }

    public XMLSchemaCache(@Nullable ErrorHandler errorHandler) {
        this(errorHandler, null);
    }

    public XMLSchemaCache(@Nullable LSResourceResolver lSResourceResolver) {
        this(null, lSResourceResolver);
    }

    public XMLSchemaCache(@Nullable ErrorHandler errorHandler, @Nullable LSResourceResolver lSResourceResolver) {
        super("XSD", XMLSchemaCache.createXSDSchemaFactory(), errorHandler, lSResourceResolver);
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static XMLSchemaCache getInstance() {
        XMLSchemaCache xMLSchemaCache = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return xMLSchemaCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static XMLSchemaCache getInstanceOfClassLoader(@Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            return XMLSchemaCache.getInstance();
        }
        String string = classLoader.toString();
        XMLSchemaCache xMLSchemaCache = null;
        s_aRWLock.readLock().lock();
        try {
            xMLSchemaCache = s_aPerClassLoaderCache.get(string);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        if (xMLSchemaCache == null) {
            s_aRWLock.writeLock().lock();
            try {
                xMLSchemaCache = s_aPerClassLoaderCache.get(string);
                if (xMLSchemaCache == null) {
                    xMLSchemaCache = new XMLSchemaCache(new SimpleLSResourceResolver(classLoader));
                    s_aPerClassLoaderCache.put(string, xMLSchemaCache);
                }
            }
            finally {
                s_aRWLock.writeLock().unlock();
            }
        }
        return xMLSchemaCache;
    }

    public static void clearPerClassLoaderCache() {
        s_aRWLock.writeLock().lock();
        try {
            s_aPerClassLoaderCache.clear();
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    private static final class SingletonHolder {
        static final XMLSchemaCache s_aInstance = new XMLSchemaCache();

        private SingletonHolder() {
        }
    }
}

