/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChildNodeIterator
implements IIterableIterator<Node> {
    private final NodeList m_aNL;
    private final int m_nMax;
    private int m_nIndex = 0;

    public ChildNodeIterator(@Nonnull Node node) {
        ValueEnforcer.notNull(node, "StartNode");
        this.m_aNL = node.getChildNodes();
        this.m_nMax = this.m_aNL.getLength();
    }

    @Override
    public boolean hasNext() {
        return this.m_nIndex < this.m_nMax;
    }

    @Override
    @Nonnull
    public Node next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Node node = this.m_aNL.item(this.m_nIndex);
        ++this.m_nIndex;
        return node;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Iterator<Node> iterator() {
        return this;
    }

    public String toString() {
        return new ToStringGenerator(this).append("nodeList", this.m_aNL).append("max", this.m_nMax).append("index", this.m_nIndex).toString();
    }
}

