/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.string.StringParser;
import com.helger.commons.typeconvert.ITypeConverter;
import com.helger.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.commons.typeconvert.ITypeConverterRegistry;
import com.helger.commons.typeconvert.rule.AbstractTypeConverterRuleAssignableSourceFixedDestination;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class DateTimeTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, String.class, new ITypeConverter(){

            @Override
            @Nonnull
            public String convert(@Nonnull Object object) {
                return Long.toString(((Calendar)object).getTimeInMillis());
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, Long.class, new ITypeConverter(){

            @Override
            @Nonnull
            public Long convert(@Nonnull Object object) {
                return ((Calendar)object).getTimeInMillis();
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, Date.class, new ITypeConverter(){

            @Override
            @Nonnull
            public Date convert(@Nonnull Object object) {
                return ((Calendar)object).getTime();
            }
        });
        iTypeConverterRegistry.registerTypeConverter(String.class, Calendar.class, new ITypeConverter(){

            @Override
            @Nonnull
            public Calendar convert(@Nonnull Object object) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(StringParser.parseLong((String)object, 0L));
                return calendar;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Calendar.class){

            @Override
            @Nonnull
            public Calendar convert(@Nonnull Object object) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(((Number)object).longValue());
                return calendar;
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Date.class, Calendar.class, new ITypeConverter(){

            @Override
            @Nonnull
            public Calendar convert(@Nonnull Object object) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)object);
                return calendar;
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Date.class, String.class, new ITypeConverter(){

            @Override
            @Nonnull
            public String convert(@Nonnull Object object) {
                return Long.toString(((Date)object).getTime());
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Date.class, Long.class, new ITypeConverter(){

            @Override
            @Nonnull
            public Long convert(@Nonnull Object object) {
                return ((Date)object).getTime();
            }
        });
        iTypeConverterRegistry.registerTypeConverter(String.class, Date.class, new ITypeConverter(){

            @Override
            @Nonnull
            public Date convert(@Nonnull Object object) {
                return new Date(StringParser.parseLong((String)object, 0L));
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Date.class){

            @Override
            @Nonnull
            public Date convert(@Nonnull Object object) {
                return new Date(((Number)object).longValue());
            }
        });
    }
}

