/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.type;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.name.IHasName;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ObjectType
implements Comparable<ObjectType>,
Serializable,
IHasName {
    private final String m_sName;
    private Integer m_aHashCode;

    public ObjectType(@Nonnull @Nonempty String string) {
        this.m_sName = ValueEnforcer.notEmpty(string, "Name");
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    public int compareTo(@Nonnull ObjectType objectType) {
        return this.m_sName.compareTo(objectType.m_sName);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ObjectType objectType = (ObjectType)object;
        return this.m_sName.equals(objectType.m_sName);
    }

    public int hashCode() {
        if (this.m_aHashCode == null) {
            this.m_aHashCode = new HashCodeGenerator(this).append(this.m_sName).getHashCodeObj();
        }
        return this.m_aHashCode;
    }

    public String toString() {
        return new ToStringGenerator(this).append("Name", this.m_sName).toString();
    }
}

