/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.display;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.compare.AbstractCollatingComparator;
import com.helger.commons.text.display.IHasDisplayText;
import java.text.Collator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CollatingComparatorHasDisplayText<DATATYPE extends IHasDisplayText>
extends AbstractCollatingComparator<DATATYPE> {
    private final Locale m_aContentLocale;

    public CollatingComparatorHasDisplayText(@Nullable Locale locale, @Nonnull Locale locale2) {
        super(locale);
        this.m_aContentLocale = ValueEnforcer.notNull(locale2, "ContentLocale");
    }

    public CollatingComparatorHasDisplayText(@Nonnull Collator collator, @Nonnull Locale locale) {
        super(collator);
        this.m_aContentLocale = ValueEnforcer.notNull(locale, "ContentLocale");
    }

    @Nonnull
    public Locale getContentLocale() {
        return this.m_aContentLocale;
    }

    @Override
    protected String getPart(@Nonnull DATATYPE DATATYPE) {
        return DATATYPE.getDisplayText(this.m_aContentLocale);
    }
}

