/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.statistics.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.statistics.IStatisticsHandler;
import com.helger.commons.statistics.IStatisticsHandlerCache;
import com.helger.commons.statistics.IStatisticsHandlerCounter;
import com.helger.commons.statistics.IStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.IStatisticsHandlerKeyedSize;
import com.helger.commons.statistics.IStatisticsHandlerKeyedTimer;
import com.helger.commons.statistics.IStatisticsHandlerSize;
import com.helger.commons.statistics.IStatisticsHandlerTimer;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.statistics.util.IStatisticsVisitorCallback;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StatisticsVisitor {
    private static final StatisticsVisitor s_aInstance = new StatisticsVisitor();

    private StatisticsVisitor() {
    }

    public static void visitStatistics(@Nonnull IStatisticsVisitorCallback iStatisticsVisitorCallback) {
        IStatisticsHandler iStatisticsHandler;
        ValueEnforcer.notNull(iStatisticsVisitorCallback, "Callback");
        List<String> list = CollectionHelper.getSorted(StatisticsManager.getAllCacheHandler());
        for (String string : list) {
            iStatisticsHandler = StatisticsManager.getCacheHandler(string);
            iStatisticsVisitorCallback.onCache(string, (IStatisticsHandlerCache)iStatisticsHandler);
        }
        list = CollectionHelper.getSorted(StatisticsManager.getAllTimerHandler());
        for (String string : list) {
            iStatisticsHandler = StatisticsManager.getTimerHandler(string);
            iStatisticsVisitorCallback.onTimer(string, (IStatisticsHandlerTimer)iStatisticsHandler);
        }
        list = CollectionHelper.getSorted(StatisticsManager.getAllKeyedTimerHandler());
        for (String string : list) {
            iStatisticsHandler = StatisticsManager.getKeyedTimerHandler(string);
            iStatisticsVisitorCallback.onKeyedTimer(string, (IStatisticsHandlerKeyedTimer)iStatisticsHandler);
        }
        list = CollectionHelper.getSorted(StatisticsManager.getAllSizeHandler());
        for (String string : list) {
            iStatisticsHandler = StatisticsManager.getSizeHandler(string);
            iStatisticsVisitorCallback.onSize(string, (IStatisticsHandlerSize)iStatisticsHandler);
        }
        list = CollectionHelper.getSorted(StatisticsManager.getAllKeyedSizeHandler());
        for (String string : list) {
            iStatisticsHandler = StatisticsManager.getKeyedSizeHandler(string);
            iStatisticsVisitorCallback.onKeyedSize(string, (IStatisticsHandlerKeyedSize)iStatisticsHandler);
        }
        list = CollectionHelper.getSorted(StatisticsManager.getAllCounterHandler());
        for (String string : list) {
            iStatisticsHandler = StatisticsManager.getCounterHandler(string);
            iStatisticsVisitorCallback.onCounter(string, (IStatisticsHandlerCounter)iStatisticsHandler);
        }
        list = CollectionHelper.getSorted(StatisticsManager.getAllKeyedCounterHandler());
        for (String string : list) {
            iStatisticsHandler = StatisticsManager.getKeyedCounterHandler(string);
            iStatisticsVisitorCallback.onKeyedCounter(string, (IStatisticsHandlerKeyedCounter)iStatisticsHandler);
        }
    }
}

