/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.serialize.convert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.serialize.convert.ISerializationConverter;
import com.helger.commons.serialize.convert.SerializationConverterRegistry;
import com.helger.commons.typeconvert.TypeConverterException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SerializationConverter {
    private static final SerializationConverter s_aInstance = new SerializationConverter();

    private SerializationConverter() {
    }

    public static void writeConvertedObject(@Nullable Object object, @Nonnull ObjectOutputStream objectOutputStream) throws TypeConverterException, IOException {
        ValueEnforcer.notNull(objectOutputStream, "ObjectOutputStream");
        objectOutputStream.writeBoolean(object == null);
        if (object != null) {
            Class<?> clazz = object.getClass();
            ISerializationConverter iSerializationConverter = SerializationConverterRegistry.getInstance().getConverter(clazz);
            if (iSerializationConverter == null) {
                throw new TypeConverterException(clazz, TypeConverterException.EReason.NO_CONVERTER_FOUND_SINGLE);
            }
            iSerializationConverter.writeConvertedObject(object, objectOutputStream);
        }
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE readConvertedObject(@Nonnull ObjectInputStream objectInputStream, @Nonnull Class<DSTTYPE> clazz) throws TypeConverterException, IOException {
        ValueEnforcer.notNull(objectInputStream, "ObjectInputStream");
        ValueEnforcer.notNull(clazz, "DestinationClass");
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            return null;
        }
        ISerializationConverter iSerializationConverter = SerializationConverterRegistry.getInstance().getConverter(clazz);
        if (iSerializationConverter == null) {
            throw new TypeConverterException(clazz, TypeConverterException.EReason.NO_CONVERTER_FOUND_SINGLE);
        }
        return (DSTTYPE)iSerializationConverter.readConvertedObject(objectInputStream);
    }
}

