/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.log;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.error.IHasErrorLevel;
import com.helger.commons.error.ISeverityComparable;
import com.helger.commons.state.IErrorIndicator;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LogMessage
implements IHasErrorLevel,
ISuccessIndicator,
IErrorIndicator,
ISeverityComparable<LogMessage>,
Serializable {
    private final Date m_aIssueDT;
    private final IErrorLevel m_aErrorLevel;
    private final Serializable m_aMsg;
    private final Throwable m_aThrowable;

    public LogMessage(@Nonnull IErrorLevel iErrorLevel, @Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this(new Date(), iErrorLevel, serializable, throwable);
    }

    public LogMessage(@Nonnull Date date, @Nonnull IErrorLevel iErrorLevel, @Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.m_aIssueDT = ValueEnforcer.notNull(date, "IssueDT");
        this.m_aErrorLevel = ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        this.m_aMsg = ValueEnforcer.notNull(serializable, "Message");
        this.m_aThrowable = throwable;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Date getIssueDateTime() {
        return (Date)this.m_aIssueDT.clone();
    }

    @Override
    @Nonnull
    public IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Nonnull
    public Serializable getMessage() {
        return this.m_aMsg;
    }

    @Nullable
    public Throwable getThrowable() {
        return this.m_aThrowable;
    }

    @Override
    public boolean isSuccess() {
        return this.m_aErrorLevel.isSuccess();
    }

    @Override
    public boolean isFailure() {
        return this.m_aErrorLevel.isFailure();
    }

    @Override
    public boolean isError() {
        return this.m_aErrorLevel.isError();
    }

    @Override
    public boolean isNoError() {
        return this.m_aErrorLevel.isNoError();
    }

    @Override
    public boolean isEqualSevereThan(@Nonnull LogMessage logMessage) {
        return this.m_aErrorLevel.isEqualSevereThan(logMessage.m_aErrorLevel);
    }

    @Override
    public boolean isLessSevereThan(@Nonnull LogMessage logMessage) {
        return this.m_aErrorLevel.isLessSevereThan(logMessage.m_aErrorLevel);
    }

    @Override
    public boolean isLessOrEqualSevereThan(@Nonnull LogMessage logMessage) {
        return this.m_aErrorLevel.isLessOrEqualSevereThan(logMessage.m_aErrorLevel);
    }

    @Override
    public boolean isMoreSevereThan(@Nonnull LogMessage logMessage) {
        return this.m_aErrorLevel.isMoreSevereThan(logMessage.m_aErrorLevel);
    }

    @Override
    public boolean isMoreOrEqualSevereThan(@Nonnull LogMessage logMessage) {
        return this.m_aErrorLevel.isMoreOrEqualSevereThan(logMessage.m_aErrorLevel);
    }

    public String toString() {
        return new ToStringGenerator(this).append("issueDT", this.m_aIssueDT).append("errorLevel", this.m_aErrorLevel).append("msg", this.m_aMsg).appendIfNotNull("throwable", this.m_aThrowable).toString();
    }
}

