/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resourceprovider;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resourceprovider.IReadableResourceProvider;
import com.helger.commons.string.ToStringGenerator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ReadableResourceProviderChain
implements IReadableResourceProvider {
    protected final List<IReadableResourceProvider> m_aReadingResourceProviders;

    public ReadableResourceProviderChain(IReadableResourceProvider ... iReadableResourceProviderArray) {
        ValueEnforcer.notEmptyNoNullValue(iReadableResourceProviderArray, "ResourceProviders");
        this.m_aReadingResourceProviders = CollectionHelper.newList(iReadableResourceProviderArray);
    }

    public ReadableResourceProviderChain(@Nonnull Iterable<? extends IReadableResourceProvider> iterable) {
        ValueEnforcer.notEmptyNoNullValue(iterable, "ResourceProviders");
        this.m_aReadingResourceProviders = CollectionHelper.newList(iterable);
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public List<IReadableResourceProvider> getAllContainedReadingResourceProviders() {
        return CollectionHelper.newList(this.m_aReadingResourceProviders);
    }

    @Override
    public final boolean supportsReading(@Nullable String string) {
        for (IReadableResourceProvider iReadableResourceProvider : this.m_aReadingResourceProviders) {
            if (!iReadableResourceProvider.supportsReading(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    @OverrideOnDemand
    public IReadableResource getReadableResource(@Nonnull String string) {
        for (IReadableResourceProvider iReadableResourceProvider : this.m_aReadingResourceProviders) {
            if (!iReadableResourceProvider.supportsReading(string)) continue;
            return iReadableResourceProvider.getReadableResource(string);
        }
        throw new IllegalArgumentException("Cannot handle reading '" + string + "' by any of " + this.m_aReadingResourceProviders);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ReadableResourceProviderChain readableResourceProviderChain = (ReadableResourceProviderChain)object;
        return this.m_aReadingResourceProviders.equals(readableResourceProviderChain.m_aReadingResourceProviders);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aReadingResourceProviders)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("resProviders", this.m_aReadingResourceProviders).toString();
    }
}

