/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.provider;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.provider.FileSystemByteStreamProvider;
import com.helger.commons.io.provider.IInputStreamProvider;
import com.helger.commons.io.provider.IOutputStreamProvider;
import com.helger.commons.io.provider.IReaderProvider;
import com.helger.commons.io.provider.IWriterProvider;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FileSystemCharStreamProvider
implements IInputStreamProvider,
IOutputStreamProvider,
IReaderProvider,
IWriterProvider {
    private final FileSystemByteStreamProvider m_aByteStreamResolver;
    private final Charset m_aCharset;

    public FileSystemCharStreamProvider(@Nonnull String string, @Nonnull Charset charset) {
        this(new File(string), charset);
    }

    public FileSystemCharStreamProvider(@Nonnull File file, @Nonnull Charset charset) {
        this.m_aByteStreamResolver = new FileSystemByteStreamProvider(file);
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    @Nonnull
    public File getBasePath() {
        return this.m_aByteStreamResolver.getBasePath();
    }

    @Nonnull
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    @Nullable
    public InputStream getInputStream(@Nonnull String string) {
        return this.m_aByteStreamResolver.getInputStream(string);
    }

    @Override
    @Nullable
    public OutputStream getOutputStream(@Nonnull String string, @Nonnull EAppend eAppend) {
        return this.m_aByteStreamResolver.getOutputStream(string, eAppend);
    }

    @Override
    @Nullable
    public Reader getReader(@Nonnull String string) {
        return StreamHelper.createReader(this.getInputStream(string), this.m_aCharset);
    }

    @Override
    @Nullable
    public Writer getWriter(@Nonnull String string, @Nonnull EAppend eAppend) {
        return StreamHelper.createWriter(this.getOutputStream(string, eAppend), this.m_aCharset);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FileSystemCharStreamProvider fileSystemCharStreamProvider = (FileSystemCharStreamProvider)object;
        return this.m_aByteStreamResolver.equals(fileSystemCharStreamProvider.m_aByteStreamResolver) && this.m_aCharset.equals(fileSystemCharStreamProvider.m_aCharset);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aByteStreamResolver).append(this.m_aCharset).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("byteStreamResolver", this.m_aByteStreamResolver).append("charset", this.m_aCharset).toString();
    }
}

