/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.iterate.FilterIterator;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.filter.FilterListAll;
import com.helger.commons.filter.IFilter;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.filter.IFileFilter;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileSystemRecursiveIterator
implements IIterableIterator<File> {
    private final int m_nStartLevel;
    private int m_nLevel = 0;
    private final IFileFilter m_aRecursionFilter;
    private final List<File> m_aFilesLeft;

    @Nonnegative
    private static int _getLevel(@Nonnull File file) {
        return StringHelper.getCharCount(file.getAbsolutePath(), File.separatorChar);
    }

    public FileSystemRecursiveIterator(@Nonnull String string) {
        this(new File(string), (IFileFilter)null);
    }

    public FileSystemRecursiveIterator(@Nonnull File file) {
        this(file, (IFileFilter)null);
    }

    public FileSystemRecursiveIterator(@Nonnull String string, @Nullable IFileFilter iFileFilter) {
        this(new File(string), iFileFilter);
    }

    public FileSystemRecursiveIterator(@Nonnull File file, @Nullable IFileFilter iFileFilter) {
        ValueEnforcer.notNull(file, "BaseDirectory");
        this.m_nStartLevel = FileSystemRecursiveIterator._getLevel(file);
        this.m_aRecursionFilter = iFileFilter;
        this.m_aFilesLeft = FileHelper.getDirectoryContent(file);
    }

    @Nonnegative
    public int getStartLevel() {
        return this.m_nStartLevel;
    }

    @Nullable
    public IFileFilter getRecursionFilter() {
        return this.m_aRecursionFilter;
    }

    @Override
    @Nonnull
    public final Iterator<File> iterator() {
        return this;
    }

    @Override
    public final boolean hasNext() {
        return !this.m_aFilesLeft.isEmpty();
    }

    @OverrideOnDemand
    protected boolean recurseIntoDirectory(@Nonnull File file) {
        return this.m_aRecursionFilter == null || this.m_aRecursionFilter.matchesFilter(file);
    }

    @Override
    @Nonnull
    public final File next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        File file = this.m_aFilesLeft.remove(0);
        this.m_nLevel = FileSystemRecursiveIterator._getLevel(file) - this.m_nStartLevel;
        if (file.isDirectory() && this.recurseIntoDirectory(file)) {
            this.m_aFilesLeft.addAll(0, FileHelper.getDirectoryContent(file));
        }
        return file;
    }

    @Nonnegative
    public final int getLevel() {
        return this.m_nLevel;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return new ToStringGenerator(this).append("files", this.m_aFilesLeft).toString();
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, @Nonnull IFileFilter iFileFilter) {
        return FileSystemRecursiveIterator.create(new File(string), iFileFilter);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, @Nonnull IFileFilter iFileFilter) {
        return new FilterIterator<File>(new FileSystemRecursiveIterator(file), (IFilter<File>)iFileFilter);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, IFileFilter ... iFileFilterArray) {
        return FileSystemRecursiveIterator.create(new File(string), iFileFilterArray);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, IFileFilter ... iFileFilterArray) {
        return new FilterIterator<File>(new FileSystemRecursiveIterator(file), (IFilter<File>)new FilterListAll(iFileFilterArray));
    }
}

