/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.i18n;

import com.helger.commons.i18n.CodepointHelper;
import com.helger.commons.i18n.ICodepointFilter;
import javax.annotation.Nonnull;

public enum ECodepointProfile {
    NONE(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return true;
        }
    }),
    ALPHA(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.isAlpha(n);
        }
    }),
    ALPHANUM(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.isAlphaDigit(n);
        }
    }),
    FRAGMENT(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.isFragment(n);
        }
    }),
    IFRAGMENT(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.is_ifragment(n);
        }
    }),
    PATH(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.isPath(n);
        }
    }),
    IPATH(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.is_ipath(n);
        }
    }),
    IUSERINFO(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.is_iuserinfo(n);
        }
    }),
    USERINFO(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.isUserInfo(n);
        }
    }),
    QUERY(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.isQuery(n);
        }
    }),
    IQUERY(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.is_iquery(n);
        }
    }),
    SCHEME(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.isScheme(n);
        }
    }),
    PATHNODELIMS(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.isPathNoDelims(n);
        }
    }),
    IPATHNODELIMS(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.is_ipathnodelims(n);
        }
    }),
    IPATHNODELIMS_SEG(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.is_ipathnodelims(n) && n != 64 && n != 58;
        }
    }),
    IREGNAME(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.is_iregname(n);
        }
    }),
    IHOST(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.is_ihost(n);
        }
    }),
    IPRIVATE(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.is_iprivate(n);
        }
    }),
    RESERVED(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.isReserved(n);
        }
    }),
    IUNRESERVED(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.is_iunreserved(n);
        }
    }),
    UNRESERVED(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.isUnreserved(n);
        }
    }),
    SCHEMESPECIFICPART(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.is_iunreserved(n) && !CodepointHelper.isReserved(n) && !CodepointHelper.is_iprivate(n) && !CodepointHelper.isPctEnc(n) && n != 35;
        }
    }),
    AUTHORITY(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.is_regname(n) && !CodepointHelper.isUserInfo(n) && !CodepointHelper.isGenDelim(n);
        }
    }),
    ASCIISANSCRLF(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.inRange(n, 1, 9) && !CodepointHelper.inRange(n, 14, 127);
        }
    }),
    PCT(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.isPctEnc(n);
        }
    }),
    STD3ASCIIRULES(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointHelper.inRange(n, 0, 44) && !CodepointHelper.inRange(n, 46, 47) && !CodepointHelper.inRange(n, 58, 64) && !CodepointHelper.inRange(n, 91, 94) && !CodepointHelper.inRange(n, 96, 96) && !CodepointHelper.inRange(n, 123, 127);
        }
    });

    private final ICodepointFilter m_aFilter;

    private ECodepointProfile(ICodepointFilter iCodepointFilter) {
        this.m_aFilter = iCodepointFilter;
    }

    @Nonnull
    public ICodepointFilter getFilter() {
        return this.m_aFilter;
    }

    public boolean check(int n) {
        return this.m_aFilter.accept(n);
    }
}

