/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.gfx;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.lru.LRUMap;
import com.helger.commons.dimension.SizeInt;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.statistics.IMutableStatisticsHandlerCache;
import com.helger.commons.statistics.StatisticsManager;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ImageDataManager {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ImageDataManager.class);
    private static final IMutableStatisticsHandlerCache s_aStatsHdl = StatisticsManager.getCacheHandler(ImageDataManager.class);
    private static boolean s_bDefaultInstantiated = false;
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final Map<IReadableResource, SizeInt> m_aImageData;
    @GuardedBy(value="m_aRWLock")
    private final Set<IReadableResource> m_aNonExistingResources = new HashSet<IReadableResource>();

    private ImageDataManager(@Nonnegative int n) {
        this.m_aImageData = new LRUMap<IReadableResource, SizeInt>(n);
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static ImageDataManager getInstance() {
        ImageDataManager imageDataManager = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return imageDataManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static SizeInt _readImageData(@Nonnull IHasInputStream iHasInputStream) {
        SizeInt sizeInt = null;
        InputStream inputStream = null;
        try {
            inputStream = iHasInputStream.getInputStream();
            if (inputStream != null) {
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                if (bufferedImage != null) {
                    sizeInt = new SizeInt(bufferedImage.getWidth(), bufferedImage.getHeight());
                } else {
                    s_aLogger.warn("Does not seem to be an image resource: " + iHasInputStream);
                }
            } else {
                s_aLogger.warn("Failed to resolve image resource: " + iHasInputStream);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            s_aLogger.error("Seems like no AWT binding is present", (Throwable)unsatisfiedLinkError);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            s_aLogger.error("Seems like no AWT binding is present", (Throwable)noClassDefFoundError);
        }
        catch (IIOException iIOException) {
            s_aLogger.error("Failed to interprete image data from resource " + iHasInputStream + ": " + iIOException.getMessage());
        }
        catch (IOException iOException) {
            s_aLogger.error("Failed to read image data from resource " + iHasInputStream, (Throwable)iOException);
        }
        catch (AccessControlException accessControlException) {
            s_aLogger.error("Whatsoever on " + iHasInputStream, (Throwable)accessControlException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            s_aLogger.error("Failed to read image data from resource " + iHasInputStream + ": " + illegalArgumentException.getMessage());
        }
        finally {
            StreamHelper.close(inputStream);
        }
        return sizeInt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SizeInt getImageSize(@Nullable IReadableResource iReadableResource) {
        SizeInt sizeInt;
        if (iReadableResource == null) {
            return null;
        }
        this.m_aRWLock.readLock().lock();
        try {
            sizeInt = this.m_aImageData.get(iReadableResource);
            if (sizeInt != null) {
                s_aStatsHdl.cacheHit();
                SizeInt sizeInt2 = sizeInt;
                return sizeInt2;
            }
            if (this.m_aNonExistingResources.contains(iReadableResource)) {
                s_aStatsHdl.cacheHit();
                SizeInt sizeInt3 = null;
                return sizeInt3;
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        sizeInt = ImageDataManager._readImageData(iReadableResource);
        this.m_aRWLock.writeLock().lock();
        try {
            if (sizeInt == null) {
                this.m_aNonExistingResources.add(iReadableResource);
            } else {
                this.m_aImageData.put(iReadableResource, sizeInt);
            }
            s_aStatsHdl.cacheMiss();
            SizeInt sizeInt4 = sizeInt;
            return sizeInt4;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Nonnull
    public EChange clearCachedSize(@Nullable IReadableResource iReadableResource) {
        if (iReadableResource != null) {
            this.m_aRWLock.writeLock().lock();
            try {
                if (this.m_aImageData.remove(iReadableResource) != null) {
                    EChange eChange = EChange.CHANGED;
                    return eChange;
                }
                if (this.m_aNonExistingResources.remove(iReadableResource)) {
                    EChange eChange = EChange.CHANGED;
                    return eChange;
                }
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        return EChange.UNCHANGED;
    }

    @Nonnull
    public EChange clearCache() {
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aImageData.isEmpty() && this.m_aNonExistingResources.isEmpty()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.m_aImageData.clear();
            this.m_aNonExistingResources.clear();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Cache was cleared: " + ImageDataManager.class.getName());
        }
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Map<IReadableResource, SizeInt> getAllCachedSizes() {
        this.m_aRWLock.readLock().lock();
        try {
            Map<IReadableResource, SizeInt> map = CollectionHelper.newMap(this.m_aImageData);
            return map;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<IReadableResource> getAllNotExistingResources() {
        this.m_aRWLock.readLock().lock();
        try {
            Set<IReadableResource> set = CollectionHelper.newSet(this.m_aNonExistingResources);
            return set;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    private static final class SingletonHolder {
        static final ImageDataManager s_aInstance = new ImageDataManager(1000);

        private SingletonHolder() {
        }
    }
}

