/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.errorlist;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.multimap.IMultiMapListBased;
import com.helger.commons.collection.multimap.MultiLinkedHashMapArrayListBased;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.errorlist.IError;
import com.helger.commons.errorlist.IErrorList;
import com.helger.commons.errorlist.SingleError;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IClearable;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ErrorList
implements IErrorList,
IClearable,
ICloneable<ErrorList> {
    private final List<IError> m_aItems = new ArrayList<IError>();

    public ErrorList() {
    }

    public ErrorList(@Nullable IErrorList iErrorList) {
        this.addAll(iErrorList);
    }

    public ErrorList(@Nullable ErrorList errorList) {
        if (errorList != null) {
            this.m_aItems.addAll(errorList.m_aItems);
        }
    }

    public ErrorList(@Nullable Collection<? extends IError> collection) {
        this.addAll(collection);
    }

    public ErrorList(IError ... iErrorArray) {
        this.addAll(iErrorArray);
    }

    public void addAll(@Nullable IErrorList iErrorList) {
        if (iErrorList != null) {
            for (IError iError : iErrorList.getAllItems()) {
                this.add(iError);
            }
        }
    }

    public void addAll(@Nullable Collection<? extends IError> collection) {
        if (collection != null) {
            for (IError iError : collection) {
                this.add(iError);
            }
        }
    }

    public void addAll(IError ... iErrorArray) {
        if (iErrorArray != null) {
            for (IError iError : iErrorArray) {
                this.add(iError);
            }
        }
    }

    public void add(@Nonnull IError iError) {
        ValueEnforcer.notNull(iError, "Item");
        this.m_aItems.add(iError);
    }

    public void addSuccess(@Nonnull @Nonempty String string) {
        this.add(SingleError.createSuccess(string));
    }

    public void addSuccess(@Nullable String string, @Nonnull @Nonempty String string2) {
        this.add(SingleError.createSuccess(string, string2));
    }

    public void addSuccess(@Nullable String string, @Nullable String string2, @Nonnull @Nonempty String string3) {
        this.add(SingleError.createSuccess(string, string2, string3));
    }

    public void addInfo(@Nonnull @Nonempty String string) {
        this.add(SingleError.createInfo(string));
    }

    public void addInfo(@Nullable String string, @Nonnull @Nonempty String string2) {
        this.add(SingleError.createInfo(string, string2));
    }

    public void addInfo(@Nullable String string, @Nullable String string2, @Nonnull @Nonempty String string3) {
        this.add(SingleError.createInfo(string, string2, string3));
    }

    public void addWarning(@Nonnull @Nonempty String string) {
        this.add(SingleError.createWarning(string));
    }

    public void addWarning(@Nullable String string, @Nonnull @Nonempty String string2) {
        this.add(SingleError.createWarning(string, string2));
    }

    public void addWarning(@Nullable String string, @Nullable String string2, @Nonnull @Nonempty String string3) {
        this.add(SingleError.createWarning(string, string2, string3));
    }

    public void addError(@Nonnull @Nonempty String string) {
        this.add(SingleError.createError(string));
    }

    public void addError(@Nullable String string, @Nonnull @Nonempty String string2) {
        this.add(SingleError.createError(string, string2));
    }

    public void addError(@Nullable String string, @Nullable String string2, @Nonnull @Nonempty String string3) {
        this.add(SingleError.createError(string, string2, string3));
    }

    @Override
    public boolean isEmpty() {
        return this.m_aItems.isEmpty();
    }

    @Override
    @Nonnegative
    public int getItemCount() {
        return this.m_aItems.size();
    }

    @Override
    public boolean hasErrorsOrWarnings() {
        for (IError iError : this.m_aItems) {
            if (!iError.getErrorLevel().isMoreOrEqualSevereThan(EErrorLevel.WARN)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsOnlySuccess() {
        if (this.m_aItems.isEmpty()) {
            return false;
        }
        for (IError iError : this.m_aItems) {
            if (!iError.isFailure()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneSuccess() {
        for (IError iError : this.m_aItems) {
            if (!iError.isSuccess()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsNoSuccess() {
        for (IError iError : this.m_aItems) {
            if (!iError.isSuccess()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnegative
    public int getSuccessCount() {
        int n = 0;
        for (IError iError : this.m_aItems) {
            if (!iError.isSuccess()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean containsOnlyFailure() {
        if (this.m_aItems.isEmpty()) {
            return false;
        }
        for (IError iError : this.m_aItems) {
            if (!iError.isSuccess()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneFailure() {
        for (IError iError : this.m_aItems) {
            if (!iError.isFailure()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsNoFailure() {
        for (IError iError : this.m_aItems) {
            if (!iError.isFailure()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnegative
    public int getFailureCount() {
        int n = 0;
        for (IError iError : this.m_aItems) {
            if (!iError.isFailure()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean containsOnlyError() {
        if (this.m_aItems.isEmpty()) {
            return false;
        }
        for (IError iError : this.m_aItems) {
            if (!iError.isNoError()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneError() {
        for (IError iError : this.m_aItems) {
            if (!iError.isError()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsNoError() {
        for (IError iError : this.m_aItems) {
            if (!iError.isError()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnegative
    public int getErrorCount() {
        int n = 0;
        for (IError iError : this.m_aItems) {
            if (!iError.isError()) continue;
            ++n;
        }
        return n;
    }

    @Override
    @Nonnull
    public IErrorLevel getMostSevereErrorLevel() {
        IErrorLevel iErrorLevel = EErrorLevel.SUCCESS;
        for (IError iError : this.m_aItems) {
            IErrorLevel iErrorLevel2 = iError.getErrorLevel();
            if (!iErrorLevel2.isMoreSevereThan(iErrorLevel)) continue;
            iErrorLevel = iErrorLevel2;
        }
        return iErrorLevel;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllItemTexts() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IError iError : this.m_aItems) {
            arrayList.add(iError.getErrorText());
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IError> getAllItems() {
        return CollectionHelper.newList(this.m_aItems);
    }

    @Override
    @Nonnull
    public Iterator<IError> iterator() {
        return this.m_aItems.iterator();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ErrorList getListWithoutField() {
        ErrorList errorList = new ErrorList();
        for (IError iError : this.m_aItems) {
            if (iError.hasErrorFieldName()) continue;
            errorList.add(iError);
        }
        return errorList;
    }

    @Override
    public boolean hasNoEntryForField(@Nullable String string) {
        return !this.hasEntryForField(string);
    }

    @Override
    public boolean hasNoEntryForFields(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!this.hasEntryForField(string)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasEntryForField(@Nullable String string) {
        for (IError iError : this.m_aItems) {
            if (!EqualsHelper.equals(string, iError.getErrorFieldName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEntryForField(@Nullable String string, @Nullable IErrorLevel iErrorLevel) {
        if (iErrorLevel != null) {
            for (IError iError : this.m_aItems) {
                if (!iError.getErrorLevel().equals(iErrorLevel) || !EqualsHelper.equals(string, iError.getErrorFieldName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasEntryForFields(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!this.hasEntryForField(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ErrorList getListOfField(@Nullable String string) {
        ErrorList errorList = new ErrorList();
        for (IError iError : this.m_aItems) {
            if (!EqualsHelper.equals(string, iError.getErrorFieldName())) continue;
            errorList.add(iError);
        }
        return errorList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ErrorList getListOfFields(String ... stringArray) {
        ErrorList errorList = new ErrorList();
        if (ArrayHelper.isNotEmpty(stringArray)) {
            for (IError iError : this.m_aItems) {
                if (!ArrayHelper.contains(stringArray, iError.getErrorFieldName())) continue;
                errorList.add(iError);
            }
        }
        return errorList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ErrorList getListOfFieldsStartingWith(String ... stringArray) {
        ErrorList errorList = new ErrorList();
        if (ArrayHelper.isNotEmpty(stringArray)) {
            block0: for (IError iError : this.m_aItems) {
                if (!iError.hasErrorFieldName()) continue;
                String string = iError.getErrorFieldName();
                for (String string2 : stringArray) {
                    if (!string.startsWith(string2)) continue;
                    errorList.add(iError);
                    continue block0;
                }
            }
        }
        return errorList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ErrorList getListOfFieldsRegExp(@Nonnull @RegEx @Nonempty String string) {
        if (StringHelper.hasNoText(string)) {
            throw new IllegalArgumentException("Empty RegExp");
        }
        ErrorList errorList = new ErrorList();
        for (IError iError : this.m_aItems) {
            if (!iError.hasErrorFieldName() || !RegExHelper.stringMatchesPattern(string, iError.getErrorFieldName())) continue;
            errorList.add(iError);
        }
        return errorList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllItemTextsOfField(@Nullable String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IError iError : this.m_aItems) {
            if (!EqualsHelper.equals(iError.getErrorFieldName(), string)) continue;
            arrayList.add(iError.getErrorText());
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllItemTextsOfFields(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (ArrayHelper.isNotEmpty(stringArray)) {
            for (IError iError : this.m_aItems) {
                if (!ArrayHelper.contains(stringArray, iError.getErrorFieldName())) continue;
                arrayList.add(iError.getErrorText());
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllItemTextsOfFieldsStartingWith(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (ArrayHelper.isNotEmpty(stringArray)) {
            block0: for (IError iError : this.m_aItems) {
                if (!iError.hasErrorFieldName()) continue;
                String string = iError.getErrorFieldName();
                for (String string2 : stringArray) {
                    if (!string.startsWith(string2)) continue;
                    arrayList.add(iError.getErrorText());
                    continue block0;
                }
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllItemTextsOfFieldsRegExp(@Nonnull @RegEx @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "RegEx");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IError iError : this.m_aItems) {
            if (!iError.hasErrorFieldName() || !RegExHelper.stringMatchesPattern(string, iError.getErrorFieldName())) continue;
            arrayList.add(iError.getErrorText());
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public IMultiMapListBased<String, IError> getStructuredByID() {
        MultiLinkedHashMapArrayListBased<String, IError> multiLinkedHashMapArrayListBased = new MultiLinkedHashMapArrayListBased<String, IError>();
        for (IError iError : this.m_aItems) {
            multiLinkedHashMapArrayListBased.putSingle(iError.getErrorID(), iError);
        }
        return multiLinkedHashMapArrayListBased;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public IMultiMapListBased<String, IError> getStructuredByFieldName() {
        MultiLinkedHashMapArrayListBased<String, IError> multiLinkedHashMapArrayListBased = new MultiLinkedHashMapArrayListBased<String, IError>();
        for (IError iError : this.m_aItems) {
            multiLinkedHashMapArrayListBased.putSingle(iError.getErrorFieldName(), iError);
        }
        return multiLinkedHashMapArrayListBased;
    }

    @Nonnull
    public EChange remove(@Nullable IError iError) {
        return EChange.valueOf(iError != null && this.m_aItems.remove(iError));
    }

    @Nonnull
    public EChange removeAll(IError ... iErrorArray) {
        EChange eChange = EChange.UNCHANGED;
        if (iErrorArray != null) {
            for (IError iError : iErrorArray) {
                eChange = eChange.or(this.remove(iError));
            }
        }
        return eChange;
    }

    @Nonnull
    public EChange removeAll(@Nullable Collection<? extends IError> collection) {
        EChange eChange = EChange.UNCHANGED;
        if (collection != null) {
            for (IError iError : collection) {
                eChange = eChange.or(this.remove(iError));
            }
        }
        return eChange;
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (this.m_aItems.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aItems.clear();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public ErrorList getClone() {
        return new ErrorList(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ErrorList errorList = (ErrorList)object;
        return this.m_aItems.equals(errorList.m_aItems);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aItems)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("items", this.m_aItems).toString();
    }
}

