/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent.collector;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.IThrowingRunnableWithParameter;
import com.helger.commons.concurrent.collector.AbstractConcurrentCollector;
import com.helger.commons.lang.GenericReflection;
import java.util.concurrent.BlockingQueue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentCollectorSingle<DATATYPE>
extends AbstractConcurrentCollector<DATATYPE> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ConcurrentCollectorSingle.class);
    private IThrowingRunnableWithParameter<DATATYPE, ? extends Throwable> m_aPerformer;

    public ConcurrentCollectorSingle() {
        this(100);
    }

    public ConcurrentCollectorSingle(@Nonnegative int n) {
        super(n);
    }

    public ConcurrentCollectorSingle(@Nonnull BlockingQueue<Object> blockingQueue) {
        super(blockingQueue);
    }

    @Nullable
    public final IThrowingRunnableWithParameter<DATATYPE, ? extends Throwable> getPerformer() {
        return this.m_aPerformer;
    }

    @Nonnull
    public final ConcurrentCollectorSingle<DATATYPE> setPerformer(@Nonnull IThrowingRunnableWithParameter<DATATYPE, ? extends Throwable> iThrowingRunnableWithParameter) {
        if (this.m_aPerformer != null) {
            throw new IllegalStateException("Another performer is already set!");
        }
        this.m_aPerformer = ValueEnforcer.notNull(iThrowingRunnableWithParameter, "Performer");
        return this;
    }

    private void _perform(DATATYPE DATATYPE) {
        try {
            this.m_aPerformer.run(DATATYPE);
        }
        catch (Throwable throwable) {
            s_aLogger.error("Failed to perform actions on object with performer " + this.m_aPerformer + " - object has been lost!", throwable);
        }
    }

    @Override
    public final void run() {
        if (this.m_aPerformer == null) {
            throw new IllegalStateException("No performer set!");
        }
        try {
            Object e;
            while ((e = this.m_aQueue.take()) != STOP_QUEUE_OBJECT) {
                this._perform(GenericReflection.uncheckedCast(e));
            }
        }
        catch (Throwable throwable) {
            s_aLogger.error("Error taking elements from queue - queue has been interrupted!!!", throwable);
        }
    }
}

