/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.compare;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.compare.ISerializableComparator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractComparator<DATATYPE>
implements ISerializableComparator<DATATYPE> {
    private ESortOrder m_eSortOrder = ESortOrder.DEFAULT;
    private boolean m_bNullValuesComeFirst = true;
    private Comparator<? super DATATYPE> m_aNestedComparator;

    @Nonnull
    public final ESortOrder getSortOrder() {
        return this.m_eSortOrder;
    }

    @Nonnull
    public final AbstractComparator<DATATYPE> setSortOrder(@Nonnull ESortOrder eSortOrder) {
        this.m_eSortOrder = ValueEnforcer.notNull(eSortOrder, "SortOrder");
        return this;
    }

    public final boolean isNullValuesComeFirst() {
        return this.m_bNullValuesComeFirst;
    }

    @Nonnull
    public final AbstractComparator<DATATYPE> setNullValuesComeFirst(boolean bl) {
        this.m_bNullValuesComeFirst = bl;
        return this;
    }

    @Nonnull
    public final Comparator<? super DATATYPE> getNestedComparator() {
        return this.m_aNestedComparator;
    }

    @Nonnull
    public final AbstractComparator<DATATYPE> setNestedComparator(@Nullable Comparator<? super DATATYPE> comparator) {
        this.m_aNestedComparator = comparator;
        return this;
    }

    protected abstract int mainCompare(@Nonnull DATATYPE var1, @Nonnull DATATYPE var2);

    @Override
    public final int compare(DATATYPE DATATYPE, DATATYPE DATATYPE2) {
        int n = DATATYPE == DATATYPE2 ? 0 : (DATATYPE == null ? (this.m_bNullValuesComeFirst ? -1 : 1) : (DATATYPE2 == null ? (this.m_bNullValuesComeFirst ? 1 : -1) : this.mainCompare(DATATYPE, DATATYPE2)));
        if (n == 0 && this.m_aNestedComparator != null) {
            n = this.m_aNestedComparator.compare(DATATYPE, DATATYPE2);
        }
        return this.m_eSortOrder.isAscending() ? n : -n;
    }

    public String toString() {
        return new ToStringGenerator(this).append("sortOrder", this.m_eSortOrder).append("nullValuesComeFirst", this.m_bNullValuesComeFirst).appendIfNotNull("nestedComparator", this.m_aNestedComparator).toString();
    }
}

