/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.convert.IConverter;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ArrayConversionHelper {
    private static final ArrayConversionHelper s_aInstance = new ArrayConversionHelper();

    private ArrayConversionHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> DSTTYPE[] newArray(@Nonnull Collection<? extends SRCTYPE> collection, @Nonnull IConverter<SRCTYPE, DSTTYPE> iConverter, @Nonnull Class<DSTTYPE> clazz) {
        ValueEnforcer.notNull(collection, "List");
        ValueEnforcer.notNull(iConverter, "Converter");
        ValueEnforcer.notNull(clazz, "DestClass");
        DSTTYPE[] DSTTYPEArray = ArrayHelper.newArray(clazz, collection.size());
        int n = 0;
        for (SRCTYPE SRCTYPE : collection) {
            DSTTYPEArray[n++] = iConverter.convert(SRCTYPE);
        }
        return DSTTYPEArray;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> DSTTYPE[] newArray(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull IConverter<SRCTYPE, DSTTYPE> iConverter, @Nonnull Class<DSTTYPE> clazz) {
        ValueEnforcer.notNull(iConverter, "Converter");
        ValueEnforcer.notNull(clazz, "DestClass");
        DSTTYPE[] DSTTYPEArray = ArrayHelper.newArray(clazz, ArrayHelper.getSize(SRCTYPEArray));
        if (SRCTYPEArray != null) {
            int n = 0;
            for (SRCTYPE SRCTYPE : SRCTYPEArray) {
                DSTTYPEArray[n++] = iConverter.convert(SRCTYPE);
            }
        }
        return DSTTYPEArray;
    }
}

