/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CCharset;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.codec.AbstractByteArrayCodec;
import com.helger.commons.codec.DecodeException;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import java.nio.charset.Charset;
import java.util.BitSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class URLCodec
extends AbstractByteArrayCodec {
    private static final byte ESCAPE_CHAR = 37;
    private static final byte SPACE = 32;
    private static final byte PLUS = 43;
    private static final BitSet PRINTABLE_CHARS;

    @Nonnull
    @ReturnsMutableCopy
    public static BitSet getDefaultBitSet() {
        return (BitSet)PRINTABLE_CHARS.clone();
    }

    public static final void writeEncodedURLByte(int n, @Nonnull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream) {
        char c = StringHelper.getHexCharUpperCase(n >> 4 & 0xF);
        char c2 = StringHelper.getHexCharUpperCase(n & 0xF);
        nonBlockingByteArrayOutputStream.write(37);
        nonBlockingByteArrayOutputStream.write(c);
        nonBlockingByteArrayOutputStream.write(c2);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getEncodedURL(@Nonnull BitSet bitSet, @Nullable byte[] byArray) {
        ValueEnforcer.notNull(bitSet, "PrintableBitSet");
        if (byArray == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(byArray.length * 2);
        for (byte by : byArray) {
            int n = by & 0xFF;
            if (bitSet.get(n)) {
                if (n == 32) {
                    nonBlockingByteArrayOutputStream.write(43);
                    continue;
                }
                nonBlockingByteArrayOutputStream.write(n);
                continue;
            }
            URLCodec.writeEncodedURLByte(n, nonBlockingByteArrayOutputStream);
        }
        return nonBlockingByteArrayOutputStream.toByteArray();
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getEncodedURL(@Nullable byte[] byArray) {
        return URLCodec.getEncodedURL(PRINTABLE_CHARS, byArray);
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public byte[] getEncoded(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return URLCodec.getEncodedURL(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @ReturnsMutableCopy
    public static byte[] getDecodedURL(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        try {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte by = byArray[i];
                if (by == 43) {
                    nonBlockingByteArrayOutputStream.write(32);
                    continue;
                }
                if (by == 37) {
                    char c;
                    int n2;
                    if (i >= n - 2) {
                        throw new DecodeException("Invalid URL encoding. Premature of string after escape char");
                    }
                    ++i;
                    char c2 = (char)byArray[i];
                    if ((n2 = StringHelper.getHexByte(c2, c = (char)byArray[++i])) < 0) {
                        throw new DecodeException("Invalid URL encoding for " + c2 + " and " + c);
                    }
                    nonBlockingByteArrayOutputStream.write(n2);
                    continue;
                }
                nonBlockingByteArrayOutputStream.write(by);
            }
            byte[] byArray2 = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            StreamHelper.close(nonBlockingByteArrayOutputStream);
        }
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getDecodedURL(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return URLCodec.getDecodedURL(CharsetManager.getAsBytes(string, CCharset.CHARSET_US_ASCII_OBJ));
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public byte[] getDecoded(@Nullable byte[] byArray) {
        return URLCodec.getDecodedURL(byArray);
    }

    @Nullable
    public static String getEncodedURLString(@Nonnull BitSet bitSet, @Nonnull byte[] byArray) {
        byte[] byArray2 = URLCodec.getEncodedURL(bitSet, byArray);
        return byArray2 == null ? null : CharsetManager.getAsString(byArray2, CCharset.CHARSET_US_ASCII_OBJ);
    }

    @Nullable
    public static String getEncodedURLString(@Nonnull byte[] byArray) {
        return URLCodec.getEncodedURLString(PRINTABLE_CHARS, byArray);
    }

    @Nullable
    public static String getEncodedURLString(@Nonnull BitSet bitSet, @Nullable String string, @Nonnull Charset charset) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        return URLCodec.getEncodedURLString(bitSet, CharsetManager.getAsBytes(string, charset));
    }

    @Nullable
    public static String getEncodedURLString(@Nullable String string, @Nonnull Charset charset) {
        return URLCodec.getEncodedURLString(PRINTABLE_CHARS, string, charset);
    }

    @Nullable
    public static String getDecodedURLString(@Nullable String string, @Nonnull Charset charset) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        return CharsetManager.getAsString(URLCodec.getDecodedURL(string), charset);
    }

    static {
        int n;
        PRINTABLE_CHARS = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        PRINTABLE_CHARS.set(45);
        PRINTABLE_CHARS.set(95);
        PRINTABLE_CHARS.set(46);
        PRINTABLE_CHARS.set(42);
        PRINTABLE_CHARS.set(32);
    }
}

