/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.codec.AbstractByteArrayDecoder;
import com.helger.commons.codec.DecodeException;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import javax.annotation.Nullable;

public class ASCII85Codec
extends AbstractByteArrayDecoder {
    private static final int BIT1 = 8;
    private static final int BIT2 = 16;
    private static final int BIT3 = 24;
    private static final int ENCODED_MAX = 117;
    private static final int ENCODED_MIN = 33;
    private static final int EIGHTY_FIVE = 85;

    @Override
    @Nullable
    @ReturnsMutableCopy
    public byte[] getDecoded(@Nullable byte[] byArray) {
        return ASCII85Codec.getDecodedASCII85(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @ReturnsMutableCopy
    public static byte[] getDecodedASCII85(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        ValueEnforcer.isTrue(byArray.length >= 4, "Buffer too small: " + byArray.length);
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        try {
            int n;
            int n2 = 0;
            byte[] byArray2 = new byte[5];
            int n3 = 0;
            if (byArray[0] == 60 && byArray[1] == 126) {
                n3 = 2;
            }
            while (n3 < byArray.length && (n = byArray[n3]) != 126) {
                if (!Character.isWhitespace(n)) {
                    if (n == 122 && n2 == 0) {
                        nonBlockingByteArrayOutputStream.write(0);
                        nonBlockingByteArrayOutputStream.write(0);
                        nonBlockingByteArrayOutputStream.write(0);
                        nonBlockingByteArrayOutputStream.write(0);
                    } else {
                        if (n < 33 || n > 117) {
                            throw new DecodeException("Illegal character in ASCII85Decode: " + n);
                        }
                        byArray2[n2] = (byte)(n - 33);
                        if (++n2 == 5) {
                            n2 = 0;
                            int n4 = 0;
                            for (int i = 0; i < 5; ++i) {
                                n4 = n4 * 85 + byArray2[i];
                            }
                            nonBlockingByteArrayOutputStream.write((byte)(n4 >> 24));
                            nonBlockingByteArrayOutputStream.write((byte)(n4 >> 16));
                            nonBlockingByteArrayOutputStream.write((byte)(n4 >> 8));
                            nonBlockingByteArrayOutputStream.write((byte)n4);
                        }
                    }
                }
                ++n3;
            }
            switch (n2) {
                case 1: {
                    throw new IllegalStateException("Unexpected end of ASCII85 encoded data!");
                }
                case 2: {
                    n = byArray2[0] * 85 * 85 * 85 * 85 + byArray2[1] * 85 * 85 * 85 + 614125 + 7225 + 85;
                    nonBlockingByteArrayOutputStream.write((byte)(n >> 24));
                    break;
                }
                case 3: {
                    n = byArray2[0] * 85 * 85 * 85 * 85 + byArray2[1] * 85 * 85 * 85 + byArray2[2] * 85 * 85 + 7225 + 85;
                    nonBlockingByteArrayOutputStream.write((byte)(n >> 24));
                    nonBlockingByteArrayOutputStream.write((byte)(n >> 16));
                    break;
                }
                case 4: {
                    n = byArray2[0] * 85 * 85 * 85 * 85 + byArray2[1] * 85 * 85 * 85 + byArray2[2] * 85 * 85 + byArray2[3] * 85 + 85;
                    nonBlockingByteArrayOutputStream.write((byte)(n >> 24));
                    nonBlockingByteArrayOutputStream.write((byte)(n >> 16));
                    nonBlockingByteArrayOutputStream.write((byte)(n >> 8));
                    break;
                }
            }
            byte[] byArray3 = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray3;
        }
        finally {
            StreamHelper.close(nonBlockingByteArrayOutputStream);
        }
    }
}

